package com.xforceplus.policymanagement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.policymanagement.entity.SalesOrderCheckResultItem;
import com.xforceplus.policymanagement.service.ISalesOrderCheckResultItemService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 销售订单对账结果关系前端控制器
 *
 * @author ultraman
 * @date 2024-12-04
 */
@RestController
public class SalesOrderCheckResultItemController {

  @Autowired
  private ISalesOrderCheckResultItemService salesOrderCheckResultItemServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param salesOrderCheckResultItem 销售订单对账结果关系
   * @return
   */
  @GetMapping("/salesordercheckresultitems" )
  public XfR getSalesOrderCheckResultItems(XfPage page, SalesOrderCheckResultItem salesOrderCheckResultItem) {
    return XfR.ok(salesOrderCheckResultItemServiceImpl.page(page, Wrappers.query(salesOrderCheckResultItem)));
  }

  /**
   * 通过id查询销售订单对账结果关系
   * @param  id
   * @return XfR
   */
  @GetMapping("/salesordercheckresultitems/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(salesOrderCheckResultItemServiceImpl.getById(id));
  }

  /**
   * 新增销售订单对账结果关系
   * @param salesOrderCheckResultItem 销售订单对账结果关系
   * @return XfR
   */
  @PostMapping("/salesordercheckresultitems")
  public XfR save(@RequestBody SalesOrderCheckResultItem salesOrderCheckResultItem) {
     return XfR.ok(salesOrderCheckResultItemServiceImpl.save(salesOrderCheckResultItem));
  }

  /**
   * 修改-传入修改后的全部数据销售订单对账结果关系
   * @param salesOrderCheckResultItem 销售订单对账结果关系
   * @return XfR
   */
  @PutMapping("/salesordercheckresultitems/{id}")
  public XfR putUpdate(@RequestBody SalesOrderCheckResultItem salesOrderCheckResultItem,@PathVariable Long id) {
      salesOrderCheckResultItem.setId(id);
      return XfR.ok(salesOrderCheckResultItemServiceImpl.updateById(salesOrderCheckResultItem));
  }

  /**
   * 修改-传入修改的数据销售订单对账结果关系
   * @param salesOrderCheckResultItem 销售订单对账结果关系
   * @return XfR
   */
  @PatchMapping("/salesordercheckresultitems/{id}")
  public XfR patchUpdate(@RequestBody SalesOrderCheckResultItem salesOrderCheckResultItem,@PathVariable Long id) {
      SalesOrderCheckResultItem upsalesOrderCheckResultItem = salesOrderCheckResultItemServiceImpl.getById(id);
      if(upsalesOrderCheckResultItem != null){
        upsalesOrderCheckResultItem = ObjectCopyUtils.copyProperties(salesOrderCheckResultItem,upsalesOrderCheckResultItem,true);
      }
      return XfR.ok(salesOrderCheckResultItemServiceImpl.updateById(upsalesOrderCheckResultItem));
  }

  /**
   * 通过id删除销售订单对账结果关系
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/salesordercheckresultitems/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(salesOrderCheckResultItemServiceImpl.removeById(id));
  }

  @PostMapping("/salesordercheckresultitems/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "sales_order_check_result_item");
     params.put("request", condition);

     return XfR.ok(salesOrderCheckResultItemServiceImpl.querys(params));
  }

}
