package com.xforceplus.policymanagement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.policymanagement.entity.Zhangwuguanli;
import com.xforceplus.policymanagement.service.IZhangwuguanliService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-12-04
 */
@RestController
public class ZhangwuguanliController {

  @Autowired
  private IZhangwuguanliService zhangwuguanliServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param zhangwuguanli ${table.comment}
   * @return
   */
  @GetMapping("/zhangwuguanlis" )
  public XfR getZhangwuguanlis(XfPage page, Zhangwuguanli zhangwuguanli) {
    return XfR.ok(zhangwuguanliServiceImpl.page(page, Wrappers.query(zhangwuguanli)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/zhangwuguanlis/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(zhangwuguanliServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param zhangwuguanli ${table.comment}
   * @return XfR
   */
  @PostMapping("/zhangwuguanlis")
  public XfR save(@RequestBody Zhangwuguanli zhangwuguanli) {
     return XfR.ok(zhangwuguanliServiceImpl.save(zhangwuguanli));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param zhangwuguanli ${table.comment}
   * @return XfR
   */
  @PutMapping("/zhangwuguanlis/{id}")
  public XfR putUpdate(@RequestBody Zhangwuguanli zhangwuguanli,@PathVariable Long id) {
      zhangwuguanli.setId(id);
      return XfR.ok(zhangwuguanliServiceImpl.updateById(zhangwuguanli));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param zhangwuguanli ${table.comment}
   * @return XfR
   */
  @PatchMapping("/zhangwuguanlis/{id}")
  public XfR patchUpdate(@RequestBody Zhangwuguanli zhangwuguanli,@PathVariable Long id) {
      Zhangwuguanli upzhangwuguanli = zhangwuguanliServiceImpl.getById(id);
      if(upzhangwuguanli != null){
        upzhangwuguanli = ObjectCopyUtils.copyProperties(zhangwuguanli,upzhangwuguanli,true);
      }
      return XfR.ok(zhangwuguanliServiceImpl.updateById(upzhangwuguanli));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/zhangwuguanlis/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(zhangwuguanliServiceImpl.removeById(id));
  }

  @PostMapping("/zhangwuguanlis/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "zhangwuguanli");
     params.put("request", condition);

     return XfR.ok(zhangwuguanliServiceImpl.querys(params));
  }

}
