package com.xforceplus.policymanagement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.policymanagement.entity.DySettlement;
import com.xforceplus.policymanagement.service.IDySettlementService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 抖音结算单前端控制器
 *
 * @author ultraman
 * @date 2024-12-04
 */
@RestController
public class DySettlementController {

  @Autowired
  private IDySettlementService dySettlementServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param dySettlement 抖音结算单
   * @return
   */
  @GetMapping("/dysettlements" )
  public XfR getDySettlements(XfPage page, DySettlement dySettlement) {
    return XfR.ok(dySettlementServiceImpl.page(page, Wrappers.query(dySettlement)));
  }

  /**
   * 通过id查询抖音结算单
   * @param  id
   * @return XfR
   */
  @GetMapping("/dysettlements/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(dySettlementServiceImpl.getById(id));
  }

  /**
   * 新增抖音结算单
   * @param dySettlement 抖音结算单
   * @return XfR
   */
  @PostMapping("/dysettlements")
  public XfR save(@RequestBody DySettlement dySettlement) {
     return XfR.ok(dySettlementServiceImpl.save(dySettlement));
  }

  /**
   * 修改-传入修改后的全部数据抖音结算单
   * @param dySettlement 抖音结算单
   * @return XfR
   */
  @PutMapping("/dysettlements/{id}")
  public XfR putUpdate(@RequestBody DySettlement dySettlement,@PathVariable Long id) {
      dySettlement.setId(id);
      return XfR.ok(dySettlementServiceImpl.updateById(dySettlement));
  }

  /**
   * 修改-传入修改的数据抖音结算单
   * @param dySettlement 抖音结算单
   * @return XfR
   */
  @PatchMapping("/dysettlements/{id}")
  public XfR patchUpdate(@RequestBody DySettlement dySettlement,@PathVariable Long id) {
      DySettlement updySettlement = dySettlementServiceImpl.getById(id);
      if(updySettlement != null){
        updySettlement = ObjectCopyUtils.copyProperties(dySettlement,updySettlement,true);
      }
      return XfR.ok(dySettlementServiceImpl.updateById(updySettlement));
  }

  /**
   * 通过id删除抖音结算单
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/dysettlements/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(dySettlementServiceImpl.removeById(id));
  }

  @PostMapping("/dysettlements/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "dy_settlement");
     params.put("request", condition);

     return XfR.ok(dySettlementServiceImpl.querys(params));
  }

}
