package com.xforceplus.policymanagement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.policymanagement.entity.Jiageguanlimain;
import com.xforceplus.policymanagement.service.IJiageguanlimainService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-12-04
 */
@RestController
public class JiageguanlimainController {

  @Autowired
  private IJiageguanlimainService jiageguanlimainServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param jiageguanlimain ${table.comment}
   * @return
   */
  @GetMapping("/jiageguanlimains" )
  public XfR getJiageguanlimains(XfPage page, Jiageguanlimain jiageguanlimain) {
    return XfR.ok(jiageguanlimainServiceImpl.page(page, Wrappers.query(jiageguanlimain)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/jiageguanlimains/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(jiageguanlimainServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param jiageguanlimain ${table.comment}
   * @return XfR
   */
  @PostMapping("/jiageguanlimains")
  public XfR save(@RequestBody Jiageguanlimain jiageguanlimain) {
     return XfR.ok(jiageguanlimainServiceImpl.save(jiageguanlimain));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param jiageguanlimain ${table.comment}
   * @return XfR
   */
  @PutMapping("/jiageguanlimains/{id}")
  public XfR putUpdate(@RequestBody Jiageguanlimain jiageguanlimain,@PathVariable Long id) {
      jiageguanlimain.setId(id);
      return XfR.ok(jiageguanlimainServiceImpl.updateById(jiageguanlimain));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param jiageguanlimain ${table.comment}
   * @return XfR
   */
  @PatchMapping("/jiageguanlimains/{id}")
  public XfR patchUpdate(@RequestBody Jiageguanlimain jiageguanlimain,@PathVariable Long id) {
      Jiageguanlimain upjiageguanlimain = jiageguanlimainServiceImpl.getById(id);
      if(upjiageguanlimain != null){
        upjiageguanlimain = ObjectCopyUtils.copyProperties(jiageguanlimain,upjiageguanlimain,true);
      }
      return XfR.ok(jiageguanlimainServiceImpl.updateById(upjiageguanlimain));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/jiageguanlimains/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(jiageguanlimainServiceImpl.removeById(id));
  }

  @PostMapping("/jiageguanlimains/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "jiageguanlimain");
     params.put("request", condition);

     return XfR.ok(jiageguanlimainServiceImpl.querys(params));
  }

}
