package com.xforceplus.policymanagement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.policymanagement.entity.SysFlowInsVarHis;
import com.xforceplus.policymanagement.service.ISysFlowInsVarHisService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 系统工作流程实例变量历史对象前端控制器
 *
 * @author ultraman
 * @date 2024-12-04
 */
@RestController
public class SysFlowInsVarHisController {

  @Autowired
  private ISysFlowInsVarHisService sysFlowInsVarHisServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param sysFlowInsVarHis 系统工作流程实例变量历史对象
   * @return
   */
  @GetMapping("/sysflowinsvarhiss" )
  public XfR getSysFlowInsVarHiss(XfPage page, SysFlowInsVarHis sysFlowInsVarHis) {
    return XfR.ok(sysFlowInsVarHisServiceImpl.page(page, Wrappers.query(sysFlowInsVarHis)));
  }

  /**
   * 通过id查询系统工作流程实例变量历史对象
   * @param  id
   * @return XfR
   */
  @GetMapping("/sysflowinsvarhiss/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(sysFlowInsVarHisServiceImpl.getById(id));
  }

  /**
   * 新增系统工作流程实例变量历史对象
   * @param sysFlowInsVarHis 系统工作流程实例变量历史对象
   * @return XfR
   */
  @PostMapping("/sysflowinsvarhiss")
  public XfR save(@RequestBody SysFlowInsVarHis sysFlowInsVarHis) {
     return XfR.ok(sysFlowInsVarHisServiceImpl.save(sysFlowInsVarHis));
  }

  /**
   * 修改-传入修改后的全部数据系统工作流程实例变量历史对象
   * @param sysFlowInsVarHis 系统工作流程实例变量历史对象
   * @return XfR
   */
  @PutMapping("/sysflowinsvarhiss/{id}")
  public XfR putUpdate(@RequestBody SysFlowInsVarHis sysFlowInsVarHis,@PathVariable Long id) {
      sysFlowInsVarHis.setId(id);
      return XfR.ok(sysFlowInsVarHisServiceImpl.updateById(sysFlowInsVarHis));
  }

  /**
   * 修改-传入修改的数据系统工作流程实例变量历史对象
   * @param sysFlowInsVarHis 系统工作流程实例变量历史对象
   * @return XfR
   */
  @PatchMapping("/sysflowinsvarhiss/{id}")
  public XfR patchUpdate(@RequestBody SysFlowInsVarHis sysFlowInsVarHis,@PathVariable Long id) {
      SysFlowInsVarHis upsysFlowInsVarHis = sysFlowInsVarHisServiceImpl.getById(id);
      if(upsysFlowInsVarHis != null){
        upsysFlowInsVarHis = ObjectCopyUtils.copyProperties(sysFlowInsVarHis,upsysFlowInsVarHis,true);
      }
      return XfR.ok(sysFlowInsVarHisServiceImpl.updateById(upsysFlowInsVarHis));
  }

  /**
   * 通过id删除系统工作流程实例变量历史对象
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/sysflowinsvarhiss/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(sysFlowInsVarHisServiceImpl.removeById(id));
  }

  @PostMapping("/sysflowinsvarhiss/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "sys_flow_ins_var_his");
     params.put("request", condition);

     return XfR.ok(sysFlowInsVarHisServiceImpl.querys(params));
  }

}
