package com.xforceplus.policymanagement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.policymanagement.entity.AfterSalesOrderCheckResultHistory;
import com.xforceplus.policymanagement.service.IAfterSalesOrderCheckResultHistoryService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 售后单对账履历前端控制器
 *
 * @author ultraman
 * @date 2024-12-09
 */
@RestController
public class AfterSalesOrderCheckResultHistoryController {

  @Autowired
  private IAfterSalesOrderCheckResultHistoryService afterSalesOrderCheckResultHistoryServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param afterSalesOrderCheckResultHistory 售后单对账履历
   * @return
   */
  @GetMapping("/aftersalesordercheckresulthistorys" )
  public XfR getAfterSalesOrderCheckResultHistorys(XfPage page, AfterSalesOrderCheckResultHistory afterSalesOrderCheckResultHistory) {
    return XfR.ok(afterSalesOrderCheckResultHistoryServiceImpl.page(page, Wrappers.query(afterSalesOrderCheckResultHistory)));
  }

  /**
   * 通过id查询售后单对账履历
   * @param  id
   * @return XfR
   */
  @GetMapping("/aftersalesordercheckresulthistorys/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(afterSalesOrderCheckResultHistoryServiceImpl.getById(id));
  }

  /**
   * 新增售后单对账履历
   * @param afterSalesOrderCheckResultHistory 售后单对账履历
   * @return XfR
   */
  @PostMapping("/aftersalesordercheckresulthistorys")
  public XfR save(@RequestBody AfterSalesOrderCheckResultHistory afterSalesOrderCheckResultHistory) {
     return XfR.ok(afterSalesOrderCheckResultHistoryServiceImpl.save(afterSalesOrderCheckResultHistory));
  }

  /**
   * 修改-传入修改后的全部数据售后单对账履历
   * @param afterSalesOrderCheckResultHistory 售后单对账履历
   * @return XfR
   */
  @PutMapping("/aftersalesordercheckresulthistorys/{id}")
  public XfR putUpdate(@RequestBody AfterSalesOrderCheckResultHistory afterSalesOrderCheckResultHistory,@PathVariable Long id) {
      afterSalesOrderCheckResultHistory.setId(id);
      return XfR.ok(afterSalesOrderCheckResultHistoryServiceImpl.updateById(afterSalesOrderCheckResultHistory));
  }

  /**
   * 修改-传入修改的数据售后单对账履历
   * @param afterSalesOrderCheckResultHistory 售后单对账履历
   * @return XfR
   */
  @PatchMapping("/aftersalesordercheckresulthistorys/{id}")
  public XfR patchUpdate(@RequestBody AfterSalesOrderCheckResultHistory afterSalesOrderCheckResultHistory,@PathVariable Long id) {
      AfterSalesOrderCheckResultHistory upafterSalesOrderCheckResultHistory = afterSalesOrderCheckResultHistoryServiceImpl.getById(id);
      if(upafterSalesOrderCheckResultHistory != null){
        upafterSalesOrderCheckResultHistory = ObjectCopyUtils.copyProperties(afterSalesOrderCheckResultHistory,upafterSalesOrderCheckResultHistory,true);
      }
      return XfR.ok(afterSalesOrderCheckResultHistoryServiceImpl.updateById(upafterSalesOrderCheckResultHistory));
  }

  /**
   * 通过id删除售后单对账履历
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/aftersalesordercheckresulthistorys/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(afterSalesOrderCheckResultHistoryServiceImpl.removeById(id));
  }

  @PostMapping("/aftersalesordercheckresulthistorys/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "after_sales_order_check_result_history");
     params.put("request", condition);

     return XfR.ok(afterSalesOrderCheckResultHistoryServiceImpl.querys(params));
  }

}
