package com.xforceplus.policymanagement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.policymanagement.entity.JdSalesOrderDetail;
import com.xforceplus.policymanagement.service.IJdSalesOrderDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-12-09
 */
@RestController
public class JdSalesOrderDetailController {

  @Autowired
  private IJdSalesOrderDetailService jdSalesOrderDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param jdSalesOrderDetail ${table.comment}
   * @return
   */
  @GetMapping("/jdsalesorderdetails" )
  public XfR getJdSalesOrderDetails(XfPage page, JdSalesOrderDetail jdSalesOrderDetail) {
    return XfR.ok(jdSalesOrderDetailServiceImpl.page(page, Wrappers.query(jdSalesOrderDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/jdsalesorderdetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(jdSalesOrderDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param jdSalesOrderDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/jdsalesorderdetails")
  public XfR save(@RequestBody JdSalesOrderDetail jdSalesOrderDetail) {
     return XfR.ok(jdSalesOrderDetailServiceImpl.save(jdSalesOrderDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param jdSalesOrderDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/jdsalesorderdetails/{id}")
  public XfR putUpdate(@RequestBody JdSalesOrderDetail jdSalesOrderDetail,@PathVariable Long id) {
      jdSalesOrderDetail.setId(id);
      return XfR.ok(jdSalesOrderDetailServiceImpl.updateById(jdSalesOrderDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param jdSalesOrderDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/jdsalesorderdetails/{id}")
  public XfR patchUpdate(@RequestBody JdSalesOrderDetail jdSalesOrderDetail,@PathVariable Long id) {
      JdSalesOrderDetail upjdSalesOrderDetail = jdSalesOrderDetailServiceImpl.getById(id);
      if(upjdSalesOrderDetail != null){
        upjdSalesOrderDetail = ObjectCopyUtils.copyProperties(jdSalesOrderDetail,upjdSalesOrderDetail,true);
      }
      return XfR.ok(jdSalesOrderDetailServiceImpl.updateById(upjdSalesOrderDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/jdsalesorderdetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(jdSalesOrderDetailServiceImpl.removeById(id));
  }

  @PostMapping("/jdsalesorderdetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "jd_sales_order_detail");
     params.put("request", condition);

     return XfR.ok(jdSalesOrderDetailServiceImpl.querys(params));
  }

}
