package com.xforceplus.policymanagement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.policymanagement.entity.PlatformSubsidyInvoiceSettlement;
import com.xforceplus.policymanagement.service.IPlatformSubsidyInvoiceSettlementService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-12-09
 */
@RestController
public class PlatformSubsidyInvoiceSettlementController {

  @Autowired
  private IPlatformSubsidyInvoiceSettlementService platformSubsidyInvoiceSettlementServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param platformSubsidyInvoiceSettlement ${table.comment}
   * @return
   */
  @GetMapping("/platformsubsidyinvoicesettlements" )
  public XfR getPlatformSubsidyInvoiceSettlements(XfPage page, PlatformSubsidyInvoiceSettlement platformSubsidyInvoiceSettlement) {
    return XfR.ok(platformSubsidyInvoiceSettlementServiceImpl.page(page, Wrappers.query(platformSubsidyInvoiceSettlement)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/platformsubsidyinvoicesettlements/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(platformSubsidyInvoiceSettlementServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param platformSubsidyInvoiceSettlement ${table.comment}
   * @return XfR
   */
  @PostMapping("/platformsubsidyinvoicesettlements")
  public XfR save(@RequestBody PlatformSubsidyInvoiceSettlement platformSubsidyInvoiceSettlement) {
     return XfR.ok(platformSubsidyInvoiceSettlementServiceImpl.save(platformSubsidyInvoiceSettlement));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param platformSubsidyInvoiceSettlement ${table.comment}
   * @return XfR
   */
  @PutMapping("/platformsubsidyinvoicesettlements/{id}")
  public XfR putUpdate(@RequestBody PlatformSubsidyInvoiceSettlement platformSubsidyInvoiceSettlement,@PathVariable Long id) {
      platformSubsidyInvoiceSettlement.setId(id);
      return XfR.ok(platformSubsidyInvoiceSettlementServiceImpl.updateById(platformSubsidyInvoiceSettlement));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param platformSubsidyInvoiceSettlement ${table.comment}
   * @return XfR
   */
  @PatchMapping("/platformsubsidyinvoicesettlements/{id}")
  public XfR patchUpdate(@RequestBody PlatformSubsidyInvoiceSettlement platformSubsidyInvoiceSettlement,@PathVariable Long id) {
      PlatformSubsidyInvoiceSettlement upplatformSubsidyInvoiceSettlement = platformSubsidyInvoiceSettlementServiceImpl.getById(id);
      if(upplatformSubsidyInvoiceSettlement != null){
        upplatformSubsidyInvoiceSettlement = ObjectCopyUtils.copyProperties(platformSubsidyInvoiceSettlement,upplatformSubsidyInvoiceSettlement,true);
      }
      return XfR.ok(platformSubsidyInvoiceSettlementServiceImpl.updateById(upplatformSubsidyInvoiceSettlement));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/platformsubsidyinvoicesettlements/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(platformSubsidyInvoiceSettlementServiceImpl.removeById(id));
  }

  @PostMapping("/platformsubsidyinvoicesettlements/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "platform_subsidy_invoice_settlement");
     params.put("request", condition);

     return XfR.ok(platformSubsidyInvoiceSettlementServiceImpl.querys(params));
  }

}
