package com.xforceplus.policymanagement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.policymanagement.entity.PlatformSubsidyInvoiceSettlementdetail;
import com.xforceplus.policymanagement.service.IPlatformSubsidyInvoiceSettlementdetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-12-09
 */
@RestController
public class PlatformSubsidyInvoiceSettlementdetailController {

  @Autowired
  private IPlatformSubsidyInvoiceSettlementdetailService platformSubsidyInvoiceSettlementdetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param platformSubsidyInvoiceSettlementdetail ${table.comment}
   * @return
   */
  @GetMapping("/platformsubsidyinvoicesettlementdetails" )
  public XfR getPlatformSubsidyInvoiceSettlementdetails(XfPage page, PlatformSubsidyInvoiceSettlementdetail platformSubsidyInvoiceSettlementdetail) {
    return XfR.ok(platformSubsidyInvoiceSettlementdetailServiceImpl.page(page, Wrappers.query(platformSubsidyInvoiceSettlementdetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/platformsubsidyinvoicesettlementdetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(platformSubsidyInvoiceSettlementdetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param platformSubsidyInvoiceSettlementdetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/platformsubsidyinvoicesettlementdetails")
  public XfR save(@RequestBody PlatformSubsidyInvoiceSettlementdetail platformSubsidyInvoiceSettlementdetail) {
     return XfR.ok(platformSubsidyInvoiceSettlementdetailServiceImpl.save(platformSubsidyInvoiceSettlementdetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param platformSubsidyInvoiceSettlementdetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/platformsubsidyinvoicesettlementdetails/{id}")
  public XfR putUpdate(@RequestBody PlatformSubsidyInvoiceSettlementdetail platformSubsidyInvoiceSettlementdetail,@PathVariable Long id) {
      platformSubsidyInvoiceSettlementdetail.setId(id);
      return XfR.ok(platformSubsidyInvoiceSettlementdetailServiceImpl.updateById(platformSubsidyInvoiceSettlementdetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param platformSubsidyInvoiceSettlementdetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/platformsubsidyinvoicesettlementdetails/{id}")
  public XfR patchUpdate(@RequestBody PlatformSubsidyInvoiceSettlementdetail platformSubsidyInvoiceSettlementdetail,@PathVariable Long id) {
      PlatformSubsidyInvoiceSettlementdetail upplatformSubsidyInvoiceSettlementdetail = platformSubsidyInvoiceSettlementdetailServiceImpl.getById(id);
      if(upplatformSubsidyInvoiceSettlementdetail != null){
        upplatformSubsidyInvoiceSettlementdetail = ObjectCopyUtils.copyProperties(platformSubsidyInvoiceSettlementdetail,upplatformSubsidyInvoiceSettlementdetail,true);
      }
      return XfR.ok(platformSubsidyInvoiceSettlementdetailServiceImpl.updateById(upplatformSubsidyInvoiceSettlementdetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/platformsubsidyinvoicesettlementdetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(platformSubsidyInvoiceSettlementdetailServiceImpl.removeById(id));
  }

  @PostMapping("/platformsubsidyinvoicesettlementdetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "platform_subsidy_invoice_settlementdetail");
     params.put("request", condition);

     return XfR.ok(platformSubsidyInvoiceSettlementdetailServiceImpl.querys(params));
  }

}
