package com.xforceplus.policymanagement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.policymanagement.entity.Jiageguanlidetail;
import com.xforceplus.policymanagement.service.IJiageguanlidetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-12-25
 */
@RestController
public class JiageguanlidetailController {

  @Autowired
  private IJiageguanlidetailService jiageguanlidetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param jiageguanlidetail ${table.comment}
   * @return
   */
  @GetMapping("/jiageguanlidetails" )
  public XfR getJiageguanlidetails(XfPage page, Jiageguanlidetail jiageguanlidetail) {
    return XfR.ok(jiageguanlidetailServiceImpl.page(page, Wrappers.query(jiageguanlidetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/jiageguanlidetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(jiageguanlidetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param jiageguanlidetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/jiageguanlidetails")
  public XfR save(@RequestBody Jiageguanlidetail jiageguanlidetail) {
     return XfR.ok(jiageguanlidetailServiceImpl.save(jiageguanlidetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param jiageguanlidetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/jiageguanlidetails/{id}")
  public XfR putUpdate(@RequestBody Jiageguanlidetail jiageguanlidetail,@PathVariable Long id) {
      jiageguanlidetail.setId(id);
      return XfR.ok(jiageguanlidetailServiceImpl.updateById(jiageguanlidetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param jiageguanlidetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/jiageguanlidetails/{id}")
  public XfR patchUpdate(@RequestBody Jiageguanlidetail jiageguanlidetail,@PathVariable Long id) {
      Jiageguanlidetail upjiageguanlidetail = jiageguanlidetailServiceImpl.getById(id);
      if(upjiageguanlidetail != null){
        upjiageguanlidetail = ObjectCopyUtils.copyProperties(jiageguanlidetail,upjiageguanlidetail,true);
      }
      return XfR.ok(jiageguanlidetailServiceImpl.updateById(upjiageguanlidetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/jiageguanlidetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(jiageguanlidetailServiceImpl.removeById(id));
  }

  @PostMapping("/jiageguanlidetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "jiageguanlidetail");
     params.put("request", condition);

     return XfR.ok(jiageguanlidetailServiceImpl.querys(params));
  }

}
