package com.xforceplus.policymanagement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.policymanagement.entity.KsSalesOrderDetail;
import com.xforceplus.policymanagement.service.IKsSalesOrderDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-12-25
 */
@RestController
public class KsSalesOrderDetailController {

  @Autowired
  private IKsSalesOrderDetailService ksSalesOrderDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ksSalesOrderDetail ${table.comment}
   * @return
   */
  @GetMapping("/kssalesorderdetails" )
  public XfR getKsSalesOrderDetails(XfPage page, KsSalesOrderDetail ksSalesOrderDetail) {
    return XfR.ok(ksSalesOrderDetailServiceImpl.page(page, Wrappers.query(ksSalesOrderDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/kssalesorderdetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ksSalesOrderDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param ksSalesOrderDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/kssalesorderdetails")
  public XfR save(@RequestBody KsSalesOrderDetail ksSalesOrderDetail) {
     return XfR.ok(ksSalesOrderDetailServiceImpl.save(ksSalesOrderDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param ksSalesOrderDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/kssalesorderdetails/{id}")
  public XfR putUpdate(@RequestBody KsSalesOrderDetail ksSalesOrderDetail,@PathVariable Long id) {
      ksSalesOrderDetail.setId(id);
      return XfR.ok(ksSalesOrderDetailServiceImpl.updateById(ksSalesOrderDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param ksSalesOrderDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/kssalesorderdetails/{id}")
  public XfR patchUpdate(@RequestBody KsSalesOrderDetail ksSalesOrderDetail,@PathVariable Long id) {
      KsSalesOrderDetail upksSalesOrderDetail = ksSalesOrderDetailServiceImpl.getById(id);
      if(upksSalesOrderDetail != null){
        upksSalesOrderDetail = ObjectCopyUtils.copyProperties(ksSalesOrderDetail,upksSalesOrderDetail,true);
      }
      return XfR.ok(ksSalesOrderDetailServiceImpl.updateById(upksSalesOrderDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/kssalesorderdetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ksSalesOrderDetailServiceImpl.removeById(id));
  }

  @PostMapping("/kssalesorderdetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ks_sales_order_detail");
     params.put("request", condition);

     return XfR.ok(ksSalesOrderDetailServiceImpl.querys(params));
  }

}
