package com.xforceplus.policymanagement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.policymanagement.entity.AfterSalesOrderCheckResultItemAfter;
import com.xforceplus.policymanagement.service.IAfterSalesOrderCheckResultItemAfterService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 售后单对账结果与售后单关系前端控制器
 *
 * @author ultraman
 * @date 2025-02-20
 */
@RestController
public class AfterSalesOrderCheckResultItemAfterController {

  @Autowired
  private IAfterSalesOrderCheckResultItemAfterService afterSalesOrderCheckResultItemAfterServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param afterSalesOrderCheckResultItemAfter 售后单对账结果与售后单关系
   * @return
   */
  @GetMapping("/aftersalesordercheckresultitemafters" )
  public XfR getAfterSalesOrderCheckResultItemAfters(XfPage page, AfterSalesOrderCheckResultItemAfter afterSalesOrderCheckResultItemAfter) {
    return XfR.ok(afterSalesOrderCheckResultItemAfterServiceImpl.page(page, Wrappers.query(afterSalesOrderCheckResultItemAfter)));
  }

  /**
   * 通过id查询售后单对账结果与售后单关系
   * @param  id
   * @return XfR
   */
  @GetMapping("/aftersalesordercheckresultitemafters/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(afterSalesOrderCheckResultItemAfterServiceImpl.getById(id));
  }

  /**
   * 新增售后单对账结果与售后单关系
   * @param afterSalesOrderCheckResultItemAfter 售后单对账结果与售后单关系
   * @return XfR
   */
  @PostMapping("/aftersalesordercheckresultitemafters")
  public XfR save(@RequestBody AfterSalesOrderCheckResultItemAfter afterSalesOrderCheckResultItemAfter) {
     return XfR.ok(afterSalesOrderCheckResultItemAfterServiceImpl.save(afterSalesOrderCheckResultItemAfter));
  }

  /**
   * 修改-传入修改后的全部数据售后单对账结果与售后单关系
   * @param afterSalesOrderCheckResultItemAfter 售后单对账结果与售后单关系
   * @return XfR
   */
  @PutMapping("/aftersalesordercheckresultitemafters/{id}")
  public XfR putUpdate(@RequestBody AfterSalesOrderCheckResultItemAfter afterSalesOrderCheckResultItemAfter,@PathVariable Long id) {
      afterSalesOrderCheckResultItemAfter.setId(id);
      return XfR.ok(afterSalesOrderCheckResultItemAfterServiceImpl.updateById(afterSalesOrderCheckResultItemAfter));
  }

  /**
   * 修改-传入修改的数据售后单对账结果与售后单关系
   * @param afterSalesOrderCheckResultItemAfter 售后单对账结果与售后单关系
   * @return XfR
   */
  @PatchMapping("/aftersalesordercheckresultitemafters/{id}")
  public XfR patchUpdate(@RequestBody AfterSalesOrderCheckResultItemAfter afterSalesOrderCheckResultItemAfter,@PathVariable Long id) {
      AfterSalesOrderCheckResultItemAfter upafterSalesOrderCheckResultItemAfter = afterSalesOrderCheckResultItemAfterServiceImpl.getById(id);
      if(upafterSalesOrderCheckResultItemAfter != null){
        upafterSalesOrderCheckResultItemAfter = ObjectCopyUtils.copyProperties(afterSalesOrderCheckResultItemAfter,upafterSalesOrderCheckResultItemAfter,true);
      }
      return XfR.ok(afterSalesOrderCheckResultItemAfterServiceImpl.updateById(upafterSalesOrderCheckResultItemAfter));
  }

  /**
   * 通过id删除售后单对账结果与售后单关系
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/aftersalesordercheckresultitemafters/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(afterSalesOrderCheckResultItemAfterServiceImpl.removeById(id));
  }

  @PostMapping("/aftersalesordercheckresultitemafters/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "after_sales_order_check_result_item_after");
     params.put("request", condition);

     return XfR.ok(afterSalesOrderCheckResultItemAfterServiceImpl.querys(params));
  }

}
