package com.xforceplus.policymanagement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.policymanagement.entity.PddSalesOrderDetail;
import com.xforceplus.policymanagement.service.IPddSalesOrderDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-02-20
 */
@RestController
public class PddSalesOrderDetailController {

  @Autowired
  private IPddSalesOrderDetailService pddSalesOrderDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param pddSalesOrderDetail ${table.comment}
   * @return
   */
  @GetMapping("/pddsalesorderdetails" )
  public XfR getPddSalesOrderDetails(XfPage page, PddSalesOrderDetail pddSalesOrderDetail) {
    return XfR.ok(pddSalesOrderDetailServiceImpl.page(page, Wrappers.query(pddSalesOrderDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/pddsalesorderdetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(pddSalesOrderDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param pddSalesOrderDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/pddsalesorderdetails")
  public XfR save(@RequestBody PddSalesOrderDetail pddSalesOrderDetail) {
     return XfR.ok(pddSalesOrderDetailServiceImpl.save(pddSalesOrderDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param pddSalesOrderDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/pddsalesorderdetails/{id}")
  public XfR putUpdate(@RequestBody PddSalesOrderDetail pddSalesOrderDetail,@PathVariable Long id) {
      pddSalesOrderDetail.setId(id);
      return XfR.ok(pddSalesOrderDetailServiceImpl.updateById(pddSalesOrderDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param pddSalesOrderDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/pddsalesorderdetails/{id}")
  public XfR patchUpdate(@RequestBody PddSalesOrderDetail pddSalesOrderDetail,@PathVariable Long id) {
      PddSalesOrderDetail uppddSalesOrderDetail = pddSalesOrderDetailServiceImpl.getById(id);
      if(uppddSalesOrderDetail != null){
        uppddSalesOrderDetail = ObjectCopyUtils.copyProperties(pddSalesOrderDetail,uppddSalesOrderDetail,true);
      }
      return XfR.ok(pddSalesOrderDetailServiceImpl.updateById(uppddSalesOrderDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/pddsalesorderdetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(pddSalesOrderDetailServiceImpl.removeById(id));
  }

  @PostMapping("/pddsalesorderdetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "pdd_sales_order_detail");
     params.put("request", condition);

     return XfR.ok(pddSalesOrderDetailServiceImpl.querys(params));
  }

}
