package com.xforceplus.policymanagement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.policymanagement.entity.ReceivableStatisticsDay;
import com.xforceplus.policymanagement.service.IReceivableStatisticsDayService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-02-20
 */
@RestController
public class ReceivableStatisticsDayController {

  @Autowired
  private IReceivableStatisticsDayService receivableStatisticsDayServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param receivableStatisticsDay ${table.comment}
   * @return
   */
  @GetMapping("/receivablestatisticsdays" )
  public XfR getReceivableStatisticsDays(XfPage page, ReceivableStatisticsDay receivableStatisticsDay) {
    return XfR.ok(receivableStatisticsDayServiceImpl.page(page, Wrappers.query(receivableStatisticsDay)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/receivablestatisticsdays/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(receivableStatisticsDayServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param receivableStatisticsDay ${table.comment}
   * @return XfR
   */
  @PostMapping("/receivablestatisticsdays")
  public XfR save(@RequestBody ReceivableStatisticsDay receivableStatisticsDay) {
     return XfR.ok(receivableStatisticsDayServiceImpl.save(receivableStatisticsDay));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param receivableStatisticsDay ${table.comment}
   * @return XfR
   */
  @PutMapping("/receivablestatisticsdays/{id}")
  public XfR putUpdate(@RequestBody ReceivableStatisticsDay receivableStatisticsDay,@PathVariable Long id) {
      receivableStatisticsDay.setId(id);
      return XfR.ok(receivableStatisticsDayServiceImpl.updateById(receivableStatisticsDay));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param receivableStatisticsDay ${table.comment}
   * @return XfR
   */
  @PatchMapping("/receivablestatisticsdays/{id}")
  public XfR patchUpdate(@RequestBody ReceivableStatisticsDay receivableStatisticsDay,@PathVariable Long id) {
      ReceivableStatisticsDay upreceivableStatisticsDay = receivableStatisticsDayServiceImpl.getById(id);
      if(upreceivableStatisticsDay != null){
        upreceivableStatisticsDay = ObjectCopyUtils.copyProperties(receivableStatisticsDay,upreceivableStatisticsDay,true);
      }
      return XfR.ok(receivableStatisticsDayServiceImpl.updateById(upreceivableStatisticsDay));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/receivablestatisticsdays/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(receivableStatisticsDayServiceImpl.removeById(id));
  }

  @PostMapping("/receivablestatisticsdays/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "receivable_statistics_day");
     params.put("request", condition);

     return XfR.ok(receivableStatisticsDayServiceImpl.querys(params));
  }

}
