package com.xforceplus.policymanagement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.policymanagement.entity.ReceiveCollectionWriteOffSummary;
import com.xforceplus.policymanagement.service.IReceiveCollectionWriteOffSummaryService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 应收单&收款单核销汇总表前端控制器
 *
 * @author ultraman
 * @date 2025-02-20
 */
@RestController
public class ReceiveCollectionWriteOffSummaryController {

  @Autowired
  private IReceiveCollectionWriteOffSummaryService receiveCollectionWriteOffSummaryServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param receiveCollectionWriteOffSummary 应收单&收款单核销汇总表
   * @return
   */
  @GetMapping("/receivecollectionwriteoffsummarys" )
  public XfR getReceiveCollectionWriteOffSummarys(XfPage page, ReceiveCollectionWriteOffSummary receiveCollectionWriteOffSummary) {
    return XfR.ok(receiveCollectionWriteOffSummaryServiceImpl.page(page, Wrappers.query(receiveCollectionWriteOffSummary)));
  }

  /**
   * 通过id查询应收单&收款单核销汇总表
   * @param  id
   * @return XfR
   */
  @GetMapping("/receivecollectionwriteoffsummarys/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(receiveCollectionWriteOffSummaryServiceImpl.getById(id));
  }

  /**
   * 新增应收单&收款单核销汇总表
   * @param receiveCollectionWriteOffSummary 应收单&收款单核销汇总表
   * @return XfR
   */
  @PostMapping("/receivecollectionwriteoffsummarys")
  public XfR save(@RequestBody ReceiveCollectionWriteOffSummary receiveCollectionWriteOffSummary) {
     return XfR.ok(receiveCollectionWriteOffSummaryServiceImpl.save(receiveCollectionWriteOffSummary));
  }

  /**
   * 修改-传入修改后的全部数据应收单&收款单核销汇总表
   * @param receiveCollectionWriteOffSummary 应收单&收款单核销汇总表
   * @return XfR
   */
  @PutMapping("/receivecollectionwriteoffsummarys/{id}")
  public XfR putUpdate(@RequestBody ReceiveCollectionWriteOffSummary receiveCollectionWriteOffSummary,@PathVariable Long id) {
      receiveCollectionWriteOffSummary.setId(id);
      return XfR.ok(receiveCollectionWriteOffSummaryServiceImpl.updateById(receiveCollectionWriteOffSummary));
  }

  /**
   * 修改-传入修改的数据应收单&收款单核销汇总表
   * @param receiveCollectionWriteOffSummary 应收单&收款单核销汇总表
   * @return XfR
   */
  @PatchMapping("/receivecollectionwriteoffsummarys/{id}")
  public XfR patchUpdate(@RequestBody ReceiveCollectionWriteOffSummary receiveCollectionWriteOffSummary,@PathVariable Long id) {
      ReceiveCollectionWriteOffSummary upreceiveCollectionWriteOffSummary = receiveCollectionWriteOffSummaryServiceImpl.getById(id);
      if(upreceiveCollectionWriteOffSummary != null){
        upreceiveCollectionWriteOffSummary = ObjectCopyUtils.copyProperties(receiveCollectionWriteOffSummary,upreceiveCollectionWriteOffSummary,true);
      }
      return XfR.ok(receiveCollectionWriteOffSummaryServiceImpl.updateById(upreceiveCollectionWriteOffSummary));
  }

  /**
   * 通过id删除应收单&收款单核销汇总表
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/receivecollectionwriteoffsummarys/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(receiveCollectionWriteOffSummaryServiceImpl.removeById(id));
  }

  @PostMapping("/receivecollectionwriteoffsummarys/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "receive_collection_write_off_summary");
     params.put("request", condition);

     return XfR.ok(receiveCollectionWriteOffSummaryServiceImpl.querys(params));
  }

}
