package com.xforceplus.policymanagement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.policymanagement.entity.SubmitSummaryTable;
import com.xforceplus.policymanagement.service.ISubmitSummaryTableService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-02-20
 */
@RestController
public class SubmitSummaryTableController {

  @Autowired
  private ISubmitSummaryTableService submitSummaryTableServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param submitSummaryTable ${table.comment}
   * @return
   */
  @GetMapping("/submitsummarytables" )
  public XfR getSubmitSummaryTables(XfPage page, SubmitSummaryTable submitSummaryTable) {
    return XfR.ok(submitSummaryTableServiceImpl.page(page, Wrappers.query(submitSummaryTable)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/submitsummarytables/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(submitSummaryTableServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param submitSummaryTable ${table.comment}
   * @return XfR
   */
  @PostMapping("/submitsummarytables")
  public XfR save(@RequestBody SubmitSummaryTable submitSummaryTable) {
     return XfR.ok(submitSummaryTableServiceImpl.save(submitSummaryTable));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param submitSummaryTable ${table.comment}
   * @return XfR
   */
  @PutMapping("/submitsummarytables/{id}")
  public XfR putUpdate(@RequestBody SubmitSummaryTable submitSummaryTable,@PathVariable Long id) {
      submitSummaryTable.setId(id);
      return XfR.ok(submitSummaryTableServiceImpl.updateById(submitSummaryTable));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param submitSummaryTable ${table.comment}
   * @return XfR
   */
  @PatchMapping("/submitsummarytables/{id}")
  public XfR patchUpdate(@RequestBody SubmitSummaryTable submitSummaryTable,@PathVariable Long id) {
      SubmitSummaryTable upsubmitSummaryTable = submitSummaryTableServiceImpl.getById(id);
      if(upsubmitSummaryTable != null){
        upsubmitSummaryTable = ObjectCopyUtils.copyProperties(submitSummaryTable,upsubmitSummaryTable,true);
      }
      return XfR.ok(submitSummaryTableServiceImpl.updateById(upsubmitSummaryTable));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/submitsummarytables/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(submitSummaryTableServiceImpl.removeById(id));
  }

  @PostMapping("/submitsummarytables/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "submit_summary_table");
     params.put("request", condition);

     return XfR.ok(submitSummaryTableServiceImpl.querys(params));
  }

}
