package com.xforceplus.policymanagement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.policymanagement.entity.SystemThirdPartyAccount;
import com.xforceplus.policymanagement.service.ISystemThirdPartyAccountService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 三方平台账号系统对象前端控制器
 *
 * @author ultraman
 * @date 2025-02-20
 */
@RestController
public class SystemThirdPartyAccountController {

  @Autowired
  private ISystemThirdPartyAccountService systemThirdPartyAccountServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param systemThirdPartyAccount 三方平台账号系统对象
   * @return
   */
  @GetMapping("/systemthirdpartyaccounts" )
  public XfR getSystemThirdPartyAccounts(XfPage page, SystemThirdPartyAccount systemThirdPartyAccount) {
    return XfR.ok(systemThirdPartyAccountServiceImpl.page(page, Wrappers.query(systemThirdPartyAccount)));
  }

  /**
   * 通过id查询三方平台账号系统对象
   * @param  id
   * @return XfR
   */
  @GetMapping("/systemthirdpartyaccounts/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(systemThirdPartyAccountServiceImpl.getById(id));
  }

  /**
   * 新增三方平台账号系统对象
   * @param systemThirdPartyAccount 三方平台账号系统对象
   * @return XfR
   */
  @PostMapping("/systemthirdpartyaccounts")
  public XfR save(@RequestBody SystemThirdPartyAccount systemThirdPartyAccount) {
     return XfR.ok(systemThirdPartyAccountServiceImpl.save(systemThirdPartyAccount));
  }

  /**
   * 修改-传入修改后的全部数据三方平台账号系统对象
   * @param systemThirdPartyAccount 三方平台账号系统对象
   * @return XfR
   */
  @PutMapping("/systemthirdpartyaccounts/{id}")
  public XfR putUpdate(@RequestBody SystemThirdPartyAccount systemThirdPartyAccount,@PathVariable Long id) {
      systemThirdPartyAccount.setId(id);
      return XfR.ok(systemThirdPartyAccountServiceImpl.updateById(systemThirdPartyAccount));
  }

  /**
   * 修改-传入修改的数据三方平台账号系统对象
   * @param systemThirdPartyAccount 三方平台账号系统对象
   * @return XfR
   */
  @PatchMapping("/systemthirdpartyaccounts/{id}")
  public XfR patchUpdate(@RequestBody SystemThirdPartyAccount systemThirdPartyAccount,@PathVariable Long id) {
      SystemThirdPartyAccount upsystemThirdPartyAccount = systemThirdPartyAccountServiceImpl.getById(id);
      if(upsystemThirdPartyAccount != null){
        upsystemThirdPartyAccount = ObjectCopyUtils.copyProperties(systemThirdPartyAccount,upsystemThirdPartyAccount,true);
      }
      return XfR.ok(systemThirdPartyAccountServiceImpl.updateById(upsystemThirdPartyAccount));
  }

  /**
   * 通过id删除三方平台账号系统对象
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/systemthirdpartyaccounts/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(systemThirdPartyAccountServiceImpl.removeById(id));
  }

  @PostMapping("/systemthirdpartyaccounts/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "system_third_party_account");
     params.put("request", condition);

     return XfR.ok(systemThirdPartyAccountServiceImpl.querys(params));
  }

}
