package com.xforceplus.policymanagement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.policymanagement.entity.WriteOffResult;
import com.xforceplus.policymanagement.service.IWriteOffResultService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 应收回款核销结果前端控制器
 *
 * @author ultraman
 * @date 2025-02-20
 */
@RestController
public class WriteOffResultController {

  @Autowired
  private IWriteOffResultService writeOffResultServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param writeOffResult 应收回款核销结果
   * @return
   */
  @GetMapping("/writeoffresults" )
  public XfR getWriteOffResults(XfPage page, WriteOffResult writeOffResult) {
    return XfR.ok(writeOffResultServiceImpl.page(page, Wrappers.query(writeOffResult)));
  }

  /**
   * 通过id查询应收回款核销结果
   * @param  id
   * @return XfR
   */
  @GetMapping("/writeoffresults/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(writeOffResultServiceImpl.getById(id));
  }

  /**
   * 新增应收回款核销结果
   * @param writeOffResult 应收回款核销结果
   * @return XfR
   */
  @PostMapping("/writeoffresults")
  public XfR save(@RequestBody WriteOffResult writeOffResult) {
     return XfR.ok(writeOffResultServiceImpl.save(writeOffResult));
  }

  /**
   * 修改-传入修改后的全部数据应收回款核销结果
   * @param writeOffResult 应收回款核销结果
   * @return XfR
   */
  @PutMapping("/writeoffresults/{id}")
  public XfR putUpdate(@RequestBody WriteOffResult writeOffResult,@PathVariable Long id) {
      writeOffResult.setId(id);
      return XfR.ok(writeOffResultServiceImpl.updateById(writeOffResult));
  }

  /**
   * 修改-传入修改的数据应收回款核销结果
   * @param writeOffResult 应收回款核销结果
   * @return XfR
   */
  @PatchMapping("/writeoffresults/{id}")
  public XfR patchUpdate(@RequestBody WriteOffResult writeOffResult,@PathVariable Long id) {
      WriteOffResult upwriteOffResult = writeOffResultServiceImpl.getById(id);
      if(upwriteOffResult != null){
        upwriteOffResult = ObjectCopyUtils.copyProperties(writeOffResult,upwriteOffResult,true);
      }
      return XfR.ok(writeOffResultServiceImpl.updateById(upwriteOffResult));
  }

  /**
   * 通过id删除应收回款核销结果
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/writeoffresults/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(writeOffResultServiceImpl.removeById(id));
  }

  @PostMapping("/writeoffresults/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "write_off_result");
     params.put("request", condition);

     return XfR.ok(writeOffResultServiceImpl.querys(params));
  }

}
