package com.xforceplus.policymanagement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.policymanagement.entity.WriteOffResultItemBill;
import com.xforceplus.policymanagement.service.IWriteOffResultItemBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 应收回款核销结果和收款单关系前端控制器
 *
 * @author ultraman
 * @date 2025-02-20
 */
@RestController
public class WriteOffResultItemBillController {

  @Autowired
  private IWriteOffResultItemBillService writeOffResultItemBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param writeOffResultItemBill 应收回款核销结果和收款单关系
   * @return
   */
  @GetMapping("/writeoffresultitembills" )
  public XfR getWriteOffResultItemBills(XfPage page, WriteOffResultItemBill writeOffResultItemBill) {
    return XfR.ok(writeOffResultItemBillServiceImpl.page(page, Wrappers.query(writeOffResultItemBill)));
  }

  /**
   * 通过id查询应收回款核销结果和收款单关系
   * @param  id
   * @return XfR
   */
  @GetMapping("/writeoffresultitembills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(writeOffResultItemBillServiceImpl.getById(id));
  }

  /**
   * 新增应收回款核销结果和收款单关系
   * @param writeOffResultItemBill 应收回款核销结果和收款单关系
   * @return XfR
   */
  @PostMapping("/writeoffresultitembills")
  public XfR save(@RequestBody WriteOffResultItemBill writeOffResultItemBill) {
     return XfR.ok(writeOffResultItemBillServiceImpl.save(writeOffResultItemBill));
  }

  /**
   * 修改-传入修改后的全部数据应收回款核销结果和收款单关系
   * @param writeOffResultItemBill 应收回款核销结果和收款单关系
   * @return XfR
   */
  @PutMapping("/writeoffresultitembills/{id}")
  public XfR putUpdate(@RequestBody WriteOffResultItemBill writeOffResultItemBill,@PathVariable Long id) {
      writeOffResultItemBill.setId(id);
      return XfR.ok(writeOffResultItemBillServiceImpl.updateById(writeOffResultItemBill));
  }

  /**
   * 修改-传入修改的数据应收回款核销结果和收款单关系
   * @param writeOffResultItemBill 应收回款核销结果和收款单关系
   * @return XfR
   */
  @PatchMapping("/writeoffresultitembills/{id}")
  public XfR patchUpdate(@RequestBody WriteOffResultItemBill writeOffResultItemBill,@PathVariable Long id) {
      WriteOffResultItemBill upwriteOffResultItemBill = writeOffResultItemBillServiceImpl.getById(id);
      if(upwriteOffResultItemBill != null){
        upwriteOffResultItemBill = ObjectCopyUtils.copyProperties(writeOffResultItemBill,upwriteOffResultItemBill,true);
      }
      return XfR.ok(writeOffResultItemBillServiceImpl.updateById(upwriteOffResultItemBill));
  }

  /**
   * 通过id删除应收回款核销结果和收款单关系
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/writeoffresultitembills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(writeOffResultItemBillServiceImpl.removeById(id));
  }

  @PostMapping("/writeoffresultitembills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "write_off_result_item_bill");
     params.put("request", condition);

     return XfR.ok(writeOffResultItemBillServiceImpl.querys(params));
  }

}
