package com.xforceplus.policymanagement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.policymanagement.entity.Accountingpolicy;
import com.xforceplus.policymanagement.service.IAccountingpolicyService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-01-13
 */
@RestController
public class AccountingpolicyController {

  @Autowired
  private IAccountingpolicyService accountingpolicyServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param accountingpolicy ${table.comment}
   * @return
   */
  @GetMapping("/accountingpolicys" )
  public XfR getAccountingpolicys(XfPage page, Accountingpolicy accountingpolicy) {
    return XfR.ok(accountingpolicyServiceImpl.page(page, Wrappers.query(accountingpolicy)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/accountingpolicys/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(accountingpolicyServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param accountingpolicy ${table.comment}
   * @return XfR
   */
  @PostMapping("/accountingpolicys")
  public XfR save(@RequestBody Accountingpolicy accountingpolicy) {
     return XfR.ok(accountingpolicyServiceImpl.save(accountingpolicy));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param accountingpolicy ${table.comment}
   * @return XfR
   */
  @PutMapping("/accountingpolicys/{id}")
  public XfR putUpdate(@RequestBody Accountingpolicy accountingpolicy,@PathVariable Long id) {
      accountingpolicy.setId(id);
      return XfR.ok(accountingpolicyServiceImpl.updateById(accountingpolicy));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param accountingpolicy ${table.comment}
   * @return XfR
   */
  @PatchMapping("/accountingpolicys/{id}")
  public XfR patchUpdate(@RequestBody Accountingpolicy accountingpolicy,@PathVariable Long id) {
      Accountingpolicy upaccountingpolicy = accountingpolicyServiceImpl.getById(id);
      if(upaccountingpolicy != null){
        upaccountingpolicy = ObjectCopyUtils.copyProperties(accountingpolicy,upaccountingpolicy,true);
      }
      return XfR.ok(accountingpolicyServiceImpl.updateById(upaccountingpolicy));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/accountingpolicys/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(accountingpolicyServiceImpl.removeById(id));
  }

  @PostMapping("/accountingpolicys/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "accountingpolicy");
     params.put("request", condition);

     return XfR.ok(accountingpolicyServiceImpl.querys(params));
  }

}
