package com.xforceplus.policymanagement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.policymanagement.entity.PolicyManagement;
import com.xforceplus.policymanagement.service.IPolicyManagementService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-01-13
 */
@RestController
public class PolicyManagementController {

  @Autowired
  private IPolicyManagementService policyManagementServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param policyManagement ${table.comment}
   * @return
   */
  @GetMapping("/policymanagements" )
  public XfR getPolicyManagements(XfPage page, PolicyManagement policyManagement) {
    return XfR.ok(policyManagementServiceImpl.page(page, Wrappers.query(policyManagement)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/policymanagements/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(policyManagementServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param policyManagement ${table.comment}
   * @return XfR
   */
  @PostMapping("/policymanagements")
  public XfR save(@RequestBody PolicyManagement policyManagement) {
     return XfR.ok(policyManagementServiceImpl.save(policyManagement));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param policyManagement ${table.comment}
   * @return XfR
   */
  @PutMapping("/policymanagements/{id}")
  public XfR putUpdate(@RequestBody PolicyManagement policyManagement,@PathVariable Long id) {
      policyManagement.setId(id);
      return XfR.ok(policyManagementServiceImpl.updateById(policyManagement));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param policyManagement ${table.comment}
   * @return XfR
   */
  @PatchMapping("/policymanagements/{id}")
  public XfR patchUpdate(@RequestBody PolicyManagement policyManagement,@PathVariable Long id) {
      PolicyManagement uppolicyManagement = policyManagementServiceImpl.getById(id);
      if(uppolicyManagement != null){
        uppolicyManagement = ObjectCopyUtils.copyProperties(policyManagement,uppolicyManagement,true);
      }
      return XfR.ok(policyManagementServiceImpl.updateById(uppolicyManagement));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/policymanagements/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(policyManagementServiceImpl.removeById(id));
  }

  @PostMapping("/policymanagements/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "policy_management");
     params.put("request", condition);

     return XfR.ok(policyManagementServiceImpl.querys(params));
  }

}
