package com.xforceplus.policymanagement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.policymanagement.entity.ReceiveCollectionWriteOffRelation;
import com.xforceplus.policymanagement.service.IReceiveCollectionWriteOffRelationService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 收款单应收单核销关系前端控制器
 *
 * @author ultraman
 * @date 2025-01-13
 */
@RestController
public class ReceiveCollectionWriteOffRelationController {

  @Autowired
  private IReceiveCollectionWriteOffRelationService receiveCollectionWriteOffRelationServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param receiveCollectionWriteOffRelation 收款单应收单核销关系
   * @return
   */
  @GetMapping("/receivecollectionwriteoffrelations" )
  public XfR getReceiveCollectionWriteOffRelations(XfPage page, ReceiveCollectionWriteOffRelation receiveCollectionWriteOffRelation) {
    return XfR.ok(receiveCollectionWriteOffRelationServiceImpl.page(page, Wrappers.query(receiveCollectionWriteOffRelation)));
  }

  /**
   * 通过id查询收款单应收单核销关系
   * @param  id
   * @return XfR
   */
  @GetMapping("/receivecollectionwriteoffrelations/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(receiveCollectionWriteOffRelationServiceImpl.getById(id));
  }

  /**
   * 新增收款单应收单核销关系
   * @param receiveCollectionWriteOffRelation 收款单应收单核销关系
   * @return XfR
   */
  @PostMapping("/receivecollectionwriteoffrelations")
  public XfR save(@RequestBody ReceiveCollectionWriteOffRelation receiveCollectionWriteOffRelation) {
     return XfR.ok(receiveCollectionWriteOffRelationServiceImpl.save(receiveCollectionWriteOffRelation));
  }

  /**
   * 修改-传入修改后的全部数据收款单应收单核销关系
   * @param receiveCollectionWriteOffRelation 收款单应收单核销关系
   * @return XfR
   */
  @PutMapping("/receivecollectionwriteoffrelations/{id}")
  public XfR putUpdate(@RequestBody ReceiveCollectionWriteOffRelation receiveCollectionWriteOffRelation,@PathVariable Long id) {
      receiveCollectionWriteOffRelation.setId(id);
      return XfR.ok(receiveCollectionWriteOffRelationServiceImpl.updateById(receiveCollectionWriteOffRelation));
  }

  /**
   * 修改-传入修改的数据收款单应收单核销关系
   * @param receiveCollectionWriteOffRelation 收款单应收单核销关系
   * @return XfR
   */
  @PatchMapping("/receivecollectionwriteoffrelations/{id}")
  public XfR patchUpdate(@RequestBody ReceiveCollectionWriteOffRelation receiveCollectionWriteOffRelation,@PathVariable Long id) {
      ReceiveCollectionWriteOffRelation upreceiveCollectionWriteOffRelation = receiveCollectionWriteOffRelationServiceImpl.getById(id);
      if(upreceiveCollectionWriteOffRelation != null){
        upreceiveCollectionWriteOffRelation = ObjectCopyUtils.copyProperties(receiveCollectionWriteOffRelation,upreceiveCollectionWriteOffRelation,true);
      }
      return XfR.ok(receiveCollectionWriteOffRelationServiceImpl.updateById(upreceiveCollectionWriteOffRelation));
  }

  /**
   * 通过id删除收款单应收单核销关系
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/receivecollectionwriteoffrelations/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(receiveCollectionWriteOffRelationServiceImpl.removeById(id));
  }

  @PostMapping("/receivecollectionwriteoffrelations/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "receive_collection_write_off_relation");
     params.put("request", condition);

     return XfR.ok(receiveCollectionWriteOffRelationServiceImpl.querys(params));
  }

}
