package com.xforceplus.policymanagement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.policymanagement.entity.WriteOffResultItemReceivableOrderSnapshot;
import com.xforceplus.policymanagement.service.IWriteOffResultItemReceivableOrderSnapshotService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 应收回款核销结果和应收订单关系快照前端控制器
 *
 * @author ultraman
 * @date 2025-01-13
 */
@RestController
public class WriteOffResultItemReceivableOrderSnapshotController {

  @Autowired
  private IWriteOffResultItemReceivableOrderSnapshotService writeOffResultItemReceivableOrderSnapshotServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param writeOffResultItemReceivableOrderSnapshot 应收回款核销结果和应收订单关系快照
   * @return
   */
  @GetMapping("/writeoffresultitemreceivableordersnapshots" )
  public XfR getWriteOffResultItemReceivableOrderSnapshots(XfPage page, WriteOffResultItemReceivableOrderSnapshot writeOffResultItemReceivableOrderSnapshot) {
    return XfR.ok(writeOffResultItemReceivableOrderSnapshotServiceImpl.page(page, Wrappers.query(writeOffResultItemReceivableOrderSnapshot)));
  }

  /**
   * 通过id查询应收回款核销结果和应收订单关系快照
   * @param  id
   * @return XfR
   */
  @GetMapping("/writeoffresultitemreceivableordersnapshots/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(writeOffResultItemReceivableOrderSnapshotServiceImpl.getById(id));
  }

  /**
   * 新增应收回款核销结果和应收订单关系快照
   * @param writeOffResultItemReceivableOrderSnapshot 应收回款核销结果和应收订单关系快照
   * @return XfR
   */
  @PostMapping("/writeoffresultitemreceivableordersnapshots")
  public XfR save(@RequestBody WriteOffResultItemReceivableOrderSnapshot writeOffResultItemReceivableOrderSnapshot) {
     return XfR.ok(writeOffResultItemReceivableOrderSnapshotServiceImpl.save(writeOffResultItemReceivableOrderSnapshot));
  }

  /**
   * 修改-传入修改后的全部数据应收回款核销结果和应收订单关系快照
   * @param writeOffResultItemReceivableOrderSnapshot 应收回款核销结果和应收订单关系快照
   * @return XfR
   */
  @PutMapping("/writeoffresultitemreceivableordersnapshots/{id}")
  public XfR putUpdate(@RequestBody WriteOffResultItemReceivableOrderSnapshot writeOffResultItemReceivableOrderSnapshot,@PathVariable Long id) {
      writeOffResultItemReceivableOrderSnapshot.setId(id);
      return XfR.ok(writeOffResultItemReceivableOrderSnapshotServiceImpl.updateById(writeOffResultItemReceivableOrderSnapshot));
  }

  /**
   * 修改-传入修改的数据应收回款核销结果和应收订单关系快照
   * @param writeOffResultItemReceivableOrderSnapshot 应收回款核销结果和应收订单关系快照
   * @return XfR
   */
  @PatchMapping("/writeoffresultitemreceivableordersnapshots/{id}")
  public XfR patchUpdate(@RequestBody WriteOffResultItemReceivableOrderSnapshot writeOffResultItemReceivableOrderSnapshot,@PathVariable Long id) {
      WriteOffResultItemReceivableOrderSnapshot upwriteOffResultItemReceivableOrderSnapshot = writeOffResultItemReceivableOrderSnapshotServiceImpl.getById(id);
      if(upwriteOffResultItemReceivableOrderSnapshot != null){
        upwriteOffResultItemReceivableOrderSnapshot = ObjectCopyUtils.copyProperties(writeOffResultItemReceivableOrderSnapshot,upwriteOffResultItemReceivableOrderSnapshot,true);
      }
      return XfR.ok(writeOffResultItemReceivableOrderSnapshotServiceImpl.updateById(upwriteOffResultItemReceivableOrderSnapshot));
  }

  /**
   * 通过id删除应收回款核销结果和应收订单关系快照
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/writeoffresultitemreceivableordersnapshots/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(writeOffResultItemReceivableOrderSnapshotServiceImpl.removeById(id));
  }

  @PostMapping("/writeoffresultitemreceivableordersnapshots/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "write_off_result_item_receivable_order_snapshot");
     params.put("request", condition);

     return XfR.ok(writeOffResultItemReceivableOrderSnapshotServiceImpl.querys(params));
  }

}
