package com.xforceplus.polyfileco.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * accept_type
 * </p>
 *
 * @author ultraman
 * @since 2025-04-08
 */
public enum AcceptType {

    _JPG(".jpg", "JPG"),
    _JPEG(".jpeg", "JPEG"),
    _PNG(".png", "PNG"),
    _PDF(".pdf", "PDF");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    AcceptType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AcceptType fromCode(String code){
        switch(code) {
            case ".jpg":
                return _JPG;
            case ".jpeg":
                return _JPEG;
            case ".png":
                return _PNG;
            case ".pdf":
                return _PDF;
            default:
                return null;
        }
    }
}
