package com.xforceplus.polyfileco.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * application_status
 * </p>
 *
 * @author ultraman
 * @since 2025-04-08
 */
public enum ApplicationStatus {

    _0("0", "待提交"),
    _1("1", "审批中"),
    _2("2", "审批通过"),
    _3("3", "审批驳回"),
    _4("4", "已撤销");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ApplicationStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ApplicationStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            default:
                return null;
        }
    }
}
