package com.xforceplus.polyfileco.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * pay_business_type
 * </p>
 *
 * @author ultraman
 * @since 2025-04-08
 */
public enum PayBusinessType {

    _0("0", "建设成本-设计类-进度款"),
    _1("1", "建设成本-设计类-结算款"),
    _2("2", "建设成本-咨询服务类-进度款"),
    _3("3", "建设成本-咨询服务类-结算款"),
    _4("4", "建设成本-工程款-首笔款"),
    _5("5", "建设成本-工程款-进度款"),
    _6("6", "建设成本-工程款-结算款"),
    _7("7", "建设成本-工程款-质保金"),
    _8("8", "建设成本-材料设备采购类-首笔款"),
    _9("9", "建设成本-材料设备采购类-进度款"),
    _10("10", "建设成本-材料设备采购类-结算款"),
    _11("11", "建设成本-材料设备采购类-质保金"),
    _12("12", "建设成本-代垫款项-代垫水电费"),
    _13("13", "建设成本-代垫款项-代垫工人工资"),
    _14("14", "建设成本-代垫款项-代垫第三方维修款"),
    _15("15", "建设成本-第三方维修-进度款"),
    _16("16", "建设成本-第三方维修-结算款");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    PayBusinessType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PayBusinessType fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            case "7":
                return _7;
            case "8":
                return _8;
            case "9":
                return _9;
            case "10":
                return _10;
            case "11":
                return _11;
            case "12":
                return _12;
            case "13":
                return _13;
            case "14":
                return _14;
            case "15":
                return _15;
            case "16":
                return _16;
            default:
                return null;
        }
    }
}
