package com.xforceplus.polyfileco.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * review_operation
 * </p>
 *
 * @author ultraman
 * @since 2025-04-08
 */
public enum ReviewOperation {

    _1("1", "提交"),
    _2("2", "通过"),
    _3("3", "驳回"),
    _4("4", "撤回"),
    _5("5", "取消"),
    _0("0", "创建"),
    _6("6", "收单");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ReviewOperation(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ReviewOperation fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "0":
                return _0;
            case "6":
                return _6;
            default:
                return null;
        }
    }
}
