package com.xforceplus.polyfileco.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 付款申请单
 * </p>
 *
 * @author ultraman
 * @since 2025-04-08
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class PayApplication implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 审核状态
   */
  private String applicationStatus;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 付款单编号
   */
  @TableField("payBillNo")
  private String payBillNo;

  /**
   * 业务编码
   */
  private String businessCode;

  /**
   * 收单状态
   */
  @TableField("receiveStatus")
  private String receiveStatus;

  /**
   * 销方名称
   */
  private String sellerName;

  /**
   * 销方税号
   */
  private String sellerTaxNo;

  /**
   * 购方名称
   */
  private String purchaserName;

  /**
   * 购方税号
   */
  private String purchaserTaxNo;

  /**
   * 发起人id
   */
  private Long starterUserId;

  /**
   * 发起人姓名
   */
  private String starterUserName;

  /**
   * 业务描述
   */
  private String businessName;

  /**
   * 付款类型
   */
  private String payType;

  /**
   * 付款阶段
   */
  private String payStage;

  /**
   * 是否工抵
   */
  private Boolean laborComp;

  /**
   * 审核时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime reviewDate;

  /**
   * 联系方式
   */
  private String contact;

  /**
   * 结算单金额
   */
  private BigDecimal billAmount;

  /**
   * 驳回原因
   */
  private String rejectReasons;

  /**
   * 结算单号
   */
  private String billNo;

  /**
   * 撤回标记
   */
  private String revokeFlag;

  /**
   * 付款业务
   */
  private String payBusiness;

  /**
   * 组织树
   */
  private String orgTree;


  /**
   * 对一关联关系 关联对象 businessTemplate
   */
    private Long relBusinessTemplateId;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("application_status", applicationStatus);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("payBillNo", payBillNo);
      map.put("business_code", businessCode);
      map.put("receiveStatus", receiveStatus);
      map.put("seller_name", sellerName);
      map.put("seller_tax_no", sellerTaxNo);
      map.put("purchaser_name", purchaserName);
      map.put("purchaser_tax_no", purchaserTaxNo);
      map.put("starter_user_id", starterUserId);
      map.put("starter_user_name", starterUserName);
      map.put("business_name", businessName);
      map.put("pay_type", payType);
      map.put("pay_stage", payStage);
      map.put("labor_comp", laborComp);
      map.put("review_date", BocpGenUtils.toTimestamp(reviewDate));
      map.put("contact", contact);
      map.put("bill_amount", billAmount);
      map.put("reject_reasons", rejectReasons);
      map.put("bill_no", billNo);
      map.put("revoke_flag", revokeFlag);
      map.put("pay_business", payBusiness);
      map.put("org_tree", orgTree);

       map.put("relBusinessTemplate.id", relBusinessTemplateId);
      return map;
  }

  public static PayApplication fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    PayApplication entity = new PayApplication();
    if(map.containsKey("application_status")) {
      Object obj = map.get("application_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setApplicationStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payBillNo")) {
      Object obj = map.get("payBillNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayBillNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("business_code")) {
      Object obj = map.get("business_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBusinessCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiveStatus")) {
      Object obj = map.get("receiveStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReceiveStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_name")) {
      Object obj = map.get("seller_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_tax_no")) {
      Object obj = map.get("seller_tax_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_name")) {
      Object obj = map.get("purchaser_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_tax_no")) {
      Object obj = map.get("purchaser_tax_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("starter_user_id")) {
      Object obj = map.get("starter_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setStarterUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setStarterUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setStarterUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("starter_user_name")) {
      Object obj = map.get("starter_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStarterUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("business_name")) {
      Object obj = map.get("business_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBusinessName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pay_type")) {
      Object obj = map.get("pay_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pay_stage")) {
      Object obj = map.get("pay_stage");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayStage((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("labor_comp")) {
      Object obj = map.get("labor_comp");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setLaborComp((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLaborComp(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("review_date")) {
      Object obj = map.get("review_date");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setReviewDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setReviewDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setReviewDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setReviewDate(null);
      }
    }
    if(map.containsKey("contact")) {
      Object obj = map.get("contact");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setContact((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bill_amount")) {
      Object obj = map.get("bill_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setBillAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setBillAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setBillAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBillAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBillAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("reject_reasons")) {
      Object obj = map.get("reject_reasons");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRejectReasons((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bill_no")) {
      Object obj = map.get("bill_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("revoke_flag")) {
      Object obj = map.get("revoke_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRevokeFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pay_business")) {
      Object obj = map.get("pay_business");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayBusiness((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("relBusinessTemplate.id")) {
        Object obj = map.get("relBusinessTemplate.id");
      if(obj instanceof Long) {
        entity.setRelBusinessTemplateId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setRelBusinessTemplateId(Long.parseLong((String)obj));
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("application_status")) {
      Object obj = map.get("application_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setApplicationStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("payBillNo")) {
      Object obj = map.get("payBillNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPayBillNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("business_code")) {
      Object obj = map.get("business_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBusinessCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("receiveStatus")) {
      Object obj = map.get("receiveStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReceiveStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_name")) {
      Object obj = map.get("seller_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_tax_no")) {
      Object obj = map.get("seller_tax_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaser_name")) {
      Object obj = map.get("purchaser_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaser_tax_no")) {
      Object obj = map.get("purchaser_tax_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("starter_user_id")) {
      Object obj = map.get("starter_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setStarterUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setStarterUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setStarterUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("starter_user_name")) {
      Object obj = map.get("starter_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStarterUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("business_name")) {
      Object obj = map.get("business_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBusinessName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pay_type")) {
      Object obj = map.get("pay_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPayType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pay_stage")) {
      Object obj = map.get("pay_stage");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPayStage((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("labor_comp")) {
      Object obj = map.get("labor_comp");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setLaborComp((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setLaborComp(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("review_date")) {
      Object obj = map.get("review_date");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setReviewDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setReviewDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setReviewDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setReviewDate(null);
      }
    }
    if(map.containsKey("contact")) {
      Object obj = map.get("contact");
      if(obj != null) {
        if(obj instanceof String) {
          this.setContact((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bill_amount")) {
      Object obj = map.get("bill_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setBillAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setBillAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setBillAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBillAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setBillAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("reject_reasons")) {
      Object obj = map.get("reject_reasons");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRejectReasons((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bill_no")) {
      Object obj = map.get("bill_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBillNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("revoke_flag")) {
      Object obj = map.get("revoke_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRevokeFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pay_business")) {
      Object obj = map.get("pay_business");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPayBusiness((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgTree((String)obj);
        }
      } else {
      }
    }
      if(map.containsKey("relBusinessTemplate.id")) {
        Object obj = map.get("relBusinessTemplate.id");
        if(obj instanceof Long) {
          this.setRelBusinessTemplateId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRelBusinessTemplateId(Long.parseLong((String)obj));
        }
      }
  }
}
