package com.xforceplus.polyfileco.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.polyfileco.entity.BusinessRuleConfig;
import com.xforceplus.polyfileco.service.IBusinessRuleConfigService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-01-17
 */
@RestController
public class BusinessRuleConfigController {

  @Autowired
  private IBusinessRuleConfigService businessRuleConfigServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param businessRuleConfig ${table.comment}
   * @return
   */
  @GetMapping("/businessruleconfigs" )
  public XfR getBusinessRuleConfigs(XfPage page, BusinessRuleConfig businessRuleConfig) {
    return XfR.ok(businessRuleConfigServiceImpl.page(page, Wrappers.query(businessRuleConfig)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/businessruleconfigs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(businessRuleConfigServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param businessRuleConfig ${table.comment}
   * @return XfR
   */
  @PostMapping("/businessruleconfigs")
  public XfR save(@RequestBody BusinessRuleConfig businessRuleConfig) {
     return XfR.ok(businessRuleConfigServiceImpl.save(businessRuleConfig));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param businessRuleConfig ${table.comment}
   * @return XfR
   */
  @PutMapping("/businessruleconfigs/{id}")
  public XfR putUpdate(@RequestBody BusinessRuleConfig businessRuleConfig,@PathVariable Long id) {
      businessRuleConfig.setId(id);
      return XfR.ok(businessRuleConfigServiceImpl.updateById(businessRuleConfig));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param businessRuleConfig ${table.comment}
   * @return XfR
   */
  @PatchMapping("/businessruleconfigs/{id}")
  public XfR patchUpdate(@RequestBody BusinessRuleConfig businessRuleConfig,@PathVariable Long id) {
      BusinessRuleConfig upbusinessRuleConfig = businessRuleConfigServiceImpl.getById(id);
      if(upbusinessRuleConfig != null){
        upbusinessRuleConfig = ObjectCopyUtils.copyProperties(businessRuleConfig,upbusinessRuleConfig,true);
      }
      return XfR.ok(businessRuleConfigServiceImpl.updateById(upbusinessRuleConfig));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/businessruleconfigs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(businessRuleConfigServiceImpl.removeById(id));
  }

  @PostMapping("/businessruleconfigs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "business_rule_config");
     params.put("request", condition);

     return XfR.ok(businessRuleConfigServiceImpl.querys(params));
  }

}
