package com.xforceplus.polyfileco.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.polyfileco.entity.BusinessTemplate;
import com.xforceplus.polyfileco.service.IBusinessTemplateService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 业务模版前端控制器
 *
 * @author ultraman
 * @date 2025-01-17
 */
@RestController
public class BusinessTemplateController {

  @Autowired
  private IBusinessTemplateService businessTemplateServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param businessTemplate 业务模版
   * @return
   */
  @GetMapping("/businesstemplates" )
  public XfR getBusinessTemplates(XfPage page, BusinessTemplate businessTemplate) {
    return XfR.ok(businessTemplateServiceImpl.page(page, Wrappers.query(businessTemplate)));
  }

  /**
   * 通过id查询业务模版
   * @param  id
   * @return XfR
   */
  @GetMapping("/businesstemplates/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(businessTemplateServiceImpl.getById(id));
  }

  /**
   * 新增业务模版
   * @param businessTemplate 业务模版
   * @return XfR
   */
  @PostMapping("/businesstemplates")
  public XfR save(@RequestBody BusinessTemplate businessTemplate) {
     return XfR.ok(businessTemplateServiceImpl.save(businessTemplate));
  }

  /**
   * 修改-传入修改后的全部数据业务模版
   * @param businessTemplate 业务模版
   * @return XfR
   */
  @PutMapping("/businesstemplates/{id}")
  public XfR putUpdate(@RequestBody BusinessTemplate businessTemplate,@PathVariable Long id) {
      businessTemplate.setId(id);
      return XfR.ok(businessTemplateServiceImpl.updateById(businessTemplate));
  }

  /**
   * 修改-传入修改的数据业务模版
   * @param businessTemplate 业务模版
   * @return XfR
   */
  @PatchMapping("/businesstemplates/{id}")
  public XfR patchUpdate(@RequestBody BusinessTemplate businessTemplate,@PathVariable Long id) {
      BusinessTemplate upbusinessTemplate = businessTemplateServiceImpl.getById(id);
      if(upbusinessTemplate != null){
        upbusinessTemplate = ObjectCopyUtils.copyProperties(businessTemplate,upbusinessTemplate,true);
      }
      return XfR.ok(businessTemplateServiceImpl.updateById(upbusinessTemplate));
  }

  /**
   * 通过id删除业务模版
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/businesstemplates/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(businessTemplateServiceImpl.removeById(id));
  }

  @PostMapping("/businesstemplates/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "business_template");
     params.put("request", condition);

     return XfR.ok(businessTemplateServiceImpl.querys(params));
  }

}
