package com.xforceplus.polyfileco.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.polyfileco.entity.FileTemplate;
import com.xforceplus.polyfileco.service.IFileTemplateService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 文件模版新前端控制器
 *
 * @author ultraman
 * @date 2025-01-17
 */
@RestController
public class FileTemplateController {

  @Autowired
  private IFileTemplateService fileTemplateServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param fileTemplate 文件模版新
   * @return
   */
  @GetMapping("/filetemplates" )
  public XfR getFileTemplates(XfPage page, FileTemplate fileTemplate) {
    return XfR.ok(fileTemplateServiceImpl.page(page, Wrappers.query(fileTemplate)));
  }

  /**
   * 通过id查询文件模版新
   * @param  id
   * @return XfR
   */
  @GetMapping("/filetemplates/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(fileTemplateServiceImpl.getById(id));
  }

  /**
   * 新增文件模版新
   * @param fileTemplate 文件模版新
   * @return XfR
   */
  @PostMapping("/filetemplates")
  public XfR save(@RequestBody FileTemplate fileTemplate) {
     return XfR.ok(fileTemplateServiceImpl.save(fileTemplate));
  }

  /**
   * 修改-传入修改后的全部数据文件模版新
   * @param fileTemplate 文件模版新
   * @return XfR
   */
  @PutMapping("/filetemplates/{id}")
  public XfR putUpdate(@RequestBody FileTemplate fileTemplate,@PathVariable Long id) {
      fileTemplate.setId(id);
      return XfR.ok(fileTemplateServiceImpl.updateById(fileTemplate));
  }

  /**
   * 修改-传入修改的数据文件模版新
   * @param fileTemplate 文件模版新
   * @return XfR
   */
  @PatchMapping("/filetemplates/{id}")
  public XfR patchUpdate(@RequestBody FileTemplate fileTemplate,@PathVariable Long id) {
      FileTemplate upfileTemplate = fileTemplateServiceImpl.getById(id);
      if(upfileTemplate != null){
        upfileTemplate = ObjectCopyUtils.copyProperties(fileTemplate,upfileTemplate,true);
      }
      return XfR.ok(fileTemplateServiceImpl.updateById(upfileTemplate));
  }

  /**
   * 通过id删除文件模版新
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/filetemplates/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(fileTemplateServiceImpl.removeById(id));
  }

  @PostMapping("/filetemplates/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "file_template");
     params.put("request", condition);

     return XfR.ok(fileTemplateServiceImpl.querys(params));
  }

}
