package com.xforceplus.polyfileco.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.polyfileco.entity.PayApplication;
import com.xforceplus.polyfileco.service.IPayApplicationService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 付款申请单前端控制器
 *
 * @author ultraman
 * @date 2025-01-17
 */
@RestController
public class PayApplicationController {

  @Autowired
  private IPayApplicationService payApplicationServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param payApplication 付款申请单
   * @return
   */
  @GetMapping("/payapplications" )
  public XfR getPayApplications(XfPage page, PayApplication payApplication) {
    return XfR.ok(payApplicationServiceImpl.page(page, Wrappers.query(payApplication)));
  }

  /**
   * 通过id查询付款申请单
   * @param  id
   * @return XfR
   */
  @GetMapping("/payapplications/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(payApplicationServiceImpl.getById(id));
  }

  /**
   * 新增付款申请单
   * @param payApplication 付款申请单
   * @return XfR
   */
  @PostMapping("/payapplications")
  public XfR save(@RequestBody PayApplication payApplication) {
     return XfR.ok(payApplicationServiceImpl.save(payApplication));
  }

  /**
   * 修改-传入修改后的全部数据付款申请单
   * @param payApplication 付款申请单
   * @return XfR
   */
  @PutMapping("/payapplications/{id}")
  public XfR putUpdate(@RequestBody PayApplication payApplication,@PathVariable Long id) {
      payApplication.setId(id);
      return XfR.ok(payApplicationServiceImpl.updateById(payApplication));
  }

  /**
   * 修改-传入修改的数据付款申请单
   * @param payApplication 付款申请单
   * @return XfR
   */
  @PatchMapping("/payapplications/{id}")
  public XfR patchUpdate(@RequestBody PayApplication payApplication,@PathVariable Long id) {
      PayApplication uppayApplication = payApplicationServiceImpl.getById(id);
      if(uppayApplication != null){
        uppayApplication = ObjectCopyUtils.copyProperties(payApplication,uppayApplication,true);
      }
      return XfR.ok(payApplicationServiceImpl.updateById(uppayApplication));
  }

  /**
   * 通过id删除付款申请单
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/payapplications/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(payApplicationServiceImpl.removeById(id));
  }

  @PostMapping("/payapplications/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "pay_application");
     params.put("request", condition);

     return XfR.ok(payApplicationServiceImpl.querys(params));
  }

}
