package com.xforceplus.polyfileco.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.polyfileco.entity.PayApplicationLog;
import com.xforceplus.polyfileco.service.IPayApplicationLogService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 审批单日志前端控制器
 *
 * @author ultraman
 * @date 2025-01-17
 */
@RestController
public class PayApplicationLogController {

  @Autowired
  private IPayApplicationLogService payApplicationLogServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param payApplicationLog 审批单日志
   * @return
   */
  @GetMapping("/payapplicationlogs" )
  public XfR getPayApplicationLogs(XfPage page, PayApplicationLog payApplicationLog) {
    return XfR.ok(payApplicationLogServiceImpl.page(page, Wrappers.query(payApplicationLog)));
  }

  /**
   * 通过id查询审批单日志
   * @param  id
   * @return XfR
   */
  @GetMapping("/payapplicationlogs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(payApplicationLogServiceImpl.getById(id));
  }

  /**
   * 新增审批单日志
   * @param payApplicationLog 审批单日志
   * @return XfR
   */
  @PostMapping("/payapplicationlogs")
  public XfR save(@RequestBody PayApplicationLog payApplicationLog) {
     return XfR.ok(payApplicationLogServiceImpl.save(payApplicationLog));
  }

  /**
   * 修改-传入修改后的全部数据审批单日志
   * @param payApplicationLog 审批单日志
   * @return XfR
   */
  @PutMapping("/payapplicationlogs/{id}")
  public XfR putUpdate(@RequestBody PayApplicationLog payApplicationLog,@PathVariable Long id) {
      payApplicationLog.setId(id);
      return XfR.ok(payApplicationLogServiceImpl.updateById(payApplicationLog));
  }

  /**
   * 修改-传入修改的数据审批单日志
   * @param payApplicationLog 审批单日志
   * @return XfR
   */
  @PatchMapping("/payapplicationlogs/{id}")
  public XfR patchUpdate(@RequestBody PayApplicationLog payApplicationLog,@PathVariable Long id) {
      PayApplicationLog uppayApplicationLog = payApplicationLogServiceImpl.getById(id);
      if(uppayApplicationLog != null){
        uppayApplicationLog = ObjectCopyUtils.copyProperties(payApplicationLog,uppayApplicationLog,true);
      }
      return XfR.ok(payApplicationLogServiceImpl.updateById(uppayApplicationLog));
  }

  /**
   * 通过id删除审批单日志
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/payapplicationlogs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(payApplicationLogServiceImpl.removeById(id));
  }

  @PostMapping("/payapplicationlogs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "pay_application_log");
     params.put("request", condition);

     return XfR.ok(payApplicationLogServiceImpl.querys(params));
  }

}
