package com.xforceplus.productstandardbizflowt.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2025-04-09
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.productstandardbizflowt.entity.BillUploadRequest;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "product-standard-biz-flow-t")
public interface BillUploadRequestFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/billUploadRequest/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param billUploadRequest ${table.comment}
   * @return R
   */
  @PostMapping("/billUploadRequest/add")
  public R save(@RequestBody BillUploadRequest billUploadRequest);

  /**
   * 修改${table.comment}
   * @param billUploadRequest ${table.comment}
   * @return R
   */
  @PostMapping("/billUploadRequest/update")
  public R updateById(@RequestBody BillUploadRequest billUploadRequest);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/billUploadRequest/del/{id}" )
  public R removeById(@PathVariable Long id);

}