package com.xforceplus.productstandardbizflowt.controller;


/**
 * 系统消息模版对象feign客户端
 *
 * @author ultraman
 * @date 2025-04-09
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.productstandardbizflowt.entity.SystemMessageTemplate;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "product-standard-biz-flow-t")
public interface SystemMessageTemplateFeignApi {

  /**
   * 通过id查询系统消息模版对象
   * @param  id
   * @return R
   */
  @GetMapping("/systemMessageTemplate/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增系统消息模版对象
   * @param systemMessageTemplate 系统消息模版对象
   * @return R
   */
  @PostMapping("/systemMessageTemplate/add")
  public R save(@RequestBody SystemMessageTemplate systemMessageTemplate);

  /**
   * 修改系统消息模版对象
   * @param systemMessageTemplate 系统消息模版对象
   * @return R
   */
  @PostMapping("/systemMessageTemplate/update")
  public R updateById(@RequestBody SystemMessageTemplate systemMessageTemplate);

  /**
   * 通过id删除系统消息模版对象
   * @param  id
   * @return R
   */
  @DeleteMapping("/systemMessageTemplate/del/{id}" )
  public R removeById(@PathVariable Long id);

}