package com.xforceplus.productstandardbizflowt.controller;


/**
 * 系统流程节点实例对象feign客户端
 *
 * @author ultraman
 * @date 2025-04-10
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.productstandardbizflowt.entity.SysFlowActIns;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "product-standard-biz-flow-t")
public interface SysFlowActInsFeignApi {

  /**
   * 通过id查询系统流程节点实例对象
   * @param  id
   * @return R
   */
  @GetMapping("/sysFlowActIns/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增系统流程节点实例对象
   * @param sysFlowActIns 系统流程节点实例对象
   * @return R
   */
  @PostMapping("/sysFlowActIns/add")
  public R save(@RequestBody SysFlowActIns sysFlowActIns);

  /**
   * 修改系统流程节点实例对象
   * @param sysFlowActIns 系统流程节点实例对象
   * @return R
   */
  @PostMapping("/sysFlowActIns/update")
  public R updateById(@RequestBody SysFlowActIns sysFlowActIns);

  /**
   * 通过id删除系统流程节点实例对象
   * @param  id
   * @return R
   */
  @DeleteMapping("/sysFlowActIns/del/{id}" )
  public R removeById(@PathVariable Long id);

}