package com.xforceplus.productstandardbizflowt.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.productstandardbizflowt.entity.BillUploadRequest;
import com.xforceplus.productstandardbizflowt.service.IBillUploadRequestService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-04-01
 */
@RestController
public class BillUploadRequestController {

  @Autowired
  private IBillUploadRequestService billUploadRequestServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param billUploadRequest ${table.comment}
   * @return
   */
  @GetMapping("/billuploadrequests" )
  public XfR getBillUploadRequests(XfPage page, BillUploadRequest billUploadRequest) {
    return XfR.ok(billUploadRequestServiceImpl.page(page, Wrappers.query(billUploadRequest)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/billuploadrequests/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(billUploadRequestServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param billUploadRequest ${table.comment}
   * @return XfR
   */
  @PostMapping("/billuploadrequests")
  public XfR save(@RequestBody BillUploadRequest billUploadRequest) {
     return XfR.ok(billUploadRequestServiceImpl.save(billUploadRequest));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param billUploadRequest ${table.comment}
   * @return XfR
   */
  @PutMapping("/billuploadrequests/{id}")
  public XfR putUpdate(@RequestBody BillUploadRequest billUploadRequest,@PathVariable Long id) {
      billUploadRequest.setId(id);
      return XfR.ok(billUploadRequestServiceImpl.updateById(billUploadRequest));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param billUploadRequest ${table.comment}
   * @return XfR
   */
  @PatchMapping("/billuploadrequests/{id}")
  public XfR patchUpdate(@RequestBody BillUploadRequest billUploadRequest,@PathVariable Long id) {
      BillUploadRequest upbillUploadRequest = billUploadRequestServiceImpl.getById(id);
      if(upbillUploadRequest != null){
        upbillUploadRequest = ObjectCopyUtils.copyProperties(billUploadRequest,upbillUploadRequest,true);
      }
      return XfR.ok(billUploadRequestServiceImpl.updateById(upbillUploadRequest));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/billuploadrequests/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(billUploadRequestServiceImpl.removeById(id));
  }

  @PostMapping("/billuploadrequests/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "bill_upload_request");
     params.put("request", condition);

     return XfR.ok(billUploadRequestServiceImpl.querys(params));
  }

}
