package com.xforceplus.productstandardbizflowt.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.productstandardbizflowt.entity.BillUploadSource;
import com.xforceplus.productstandardbizflowt.service.IBillUploadSourceService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-04-01
 */
@RestController
public class BillUploadSourceController {

  @Autowired
  private IBillUploadSourceService billUploadSourceServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param billUploadSource ${table.comment}
   * @return
   */
  @GetMapping("/billuploadsources" )
  public XfR getBillUploadSources(XfPage page, BillUploadSource billUploadSource) {
    return XfR.ok(billUploadSourceServiceImpl.page(page, Wrappers.query(billUploadSource)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/billuploadsources/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(billUploadSourceServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param billUploadSource ${table.comment}
   * @return XfR
   */
  @PostMapping("/billuploadsources")
  public XfR save(@RequestBody BillUploadSource billUploadSource) {
     return XfR.ok(billUploadSourceServiceImpl.save(billUploadSource));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param billUploadSource ${table.comment}
   * @return XfR
   */
  @PutMapping("/billuploadsources/{id}")
  public XfR putUpdate(@RequestBody BillUploadSource billUploadSource,@PathVariable Long id) {
      billUploadSource.setId(id);
      return XfR.ok(billUploadSourceServiceImpl.updateById(billUploadSource));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param billUploadSource ${table.comment}
   * @return XfR
   */
  @PatchMapping("/billuploadsources/{id}")
  public XfR patchUpdate(@RequestBody BillUploadSource billUploadSource,@PathVariable Long id) {
      BillUploadSource upbillUploadSource = billUploadSourceServiceImpl.getById(id);
      if(upbillUploadSource != null){
        upbillUploadSource = ObjectCopyUtils.copyProperties(billUploadSource,upbillUploadSource,true);
      }
      return XfR.ok(billUploadSourceServiceImpl.updateById(upbillUploadSource));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/billuploadsources/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(billUploadSourceServiceImpl.removeById(id));
  }

  @PostMapping("/billuploadsources/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "bill_upload_source");
     params.put("request", condition);

     return XfR.ok(billUploadSourceServiceImpl.querys(params));
  }

}
