package com.xforceplus.productstandardbizflowt.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.productstandardbizflowt.entity.InvoiceDeliveryRequest;
import com.xforceplus.productstandardbizflowt.service.IInvoiceDeliveryRequestService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-04-01
 */
@RestController
public class InvoiceDeliveryRequestController {

  @Autowired
  private IInvoiceDeliveryRequestService invoiceDeliveryRequestServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceDeliveryRequest ${table.comment}
   * @return
   */
  @GetMapping("/invoicedeliveryrequests" )
  public XfR getInvoiceDeliveryRequests(XfPage page, InvoiceDeliveryRequest invoiceDeliveryRequest) {
    return XfR.ok(invoiceDeliveryRequestServiceImpl.page(page, Wrappers.query(invoiceDeliveryRequest)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoicedeliveryrequests/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceDeliveryRequestServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param invoiceDeliveryRequest ${table.comment}
   * @return XfR
   */
  @PostMapping("/invoicedeliveryrequests")
  public XfR save(@RequestBody InvoiceDeliveryRequest invoiceDeliveryRequest) {
     return XfR.ok(invoiceDeliveryRequestServiceImpl.save(invoiceDeliveryRequest));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param invoiceDeliveryRequest ${table.comment}
   * @return XfR
   */
  @PutMapping("/invoicedeliveryrequests/{id}")
  public XfR putUpdate(@RequestBody InvoiceDeliveryRequest invoiceDeliveryRequest,@PathVariable Long id) {
      invoiceDeliveryRequest.setId(id);
      return XfR.ok(invoiceDeliveryRequestServiceImpl.updateById(invoiceDeliveryRequest));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param invoiceDeliveryRequest ${table.comment}
   * @return XfR
   */
  @PatchMapping("/invoicedeliveryrequests/{id}")
  public XfR patchUpdate(@RequestBody InvoiceDeliveryRequest invoiceDeliveryRequest,@PathVariable Long id) {
      InvoiceDeliveryRequest upinvoiceDeliveryRequest = invoiceDeliveryRequestServiceImpl.getById(id);
      if(upinvoiceDeliveryRequest != null){
        upinvoiceDeliveryRequest = ObjectCopyUtils.copyProperties(invoiceDeliveryRequest,upinvoiceDeliveryRequest,true);
      }
      return XfR.ok(invoiceDeliveryRequestServiceImpl.updateById(upinvoiceDeliveryRequest));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoicedeliveryrequests/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceDeliveryRequestServiceImpl.removeById(id));
  }

  @PostMapping("/invoicedeliveryrequests/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_delivery_request");
     params.put("request", condition);

     return XfR.ok(invoiceDeliveryRequestServiceImpl.querys(params));
  }

}
