package com.xforceplus.productstandardbizflowt.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.productstandardbizflowt.entity.InvoiceDeliverySource;
import com.xforceplus.productstandardbizflowt.service.IInvoiceDeliverySourceService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-04-01
 */
@RestController
public class InvoiceDeliverySourceController {

  @Autowired
  private IInvoiceDeliverySourceService invoiceDeliverySourceServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceDeliverySource ${table.comment}
   * @return
   */
  @GetMapping("/invoicedeliverysources" )
  public XfR getInvoiceDeliverySources(XfPage page, InvoiceDeliverySource invoiceDeliverySource) {
    return XfR.ok(invoiceDeliverySourceServiceImpl.page(page, Wrappers.query(invoiceDeliverySource)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoicedeliverysources/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceDeliverySourceServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param invoiceDeliverySource ${table.comment}
   * @return XfR
   */
  @PostMapping("/invoicedeliverysources")
  public XfR save(@RequestBody InvoiceDeliverySource invoiceDeliverySource) {
     return XfR.ok(invoiceDeliverySourceServiceImpl.save(invoiceDeliverySource));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param invoiceDeliverySource ${table.comment}
   * @return XfR
   */
  @PutMapping("/invoicedeliverysources/{id}")
  public XfR putUpdate(@RequestBody InvoiceDeliverySource invoiceDeliverySource,@PathVariable Long id) {
      invoiceDeliverySource.setId(id);
      return XfR.ok(invoiceDeliverySourceServiceImpl.updateById(invoiceDeliverySource));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param invoiceDeliverySource ${table.comment}
   * @return XfR
   */
  @PatchMapping("/invoicedeliverysources/{id}")
  public XfR patchUpdate(@RequestBody InvoiceDeliverySource invoiceDeliverySource,@PathVariable Long id) {
      InvoiceDeliverySource upinvoiceDeliverySource = invoiceDeliverySourceServiceImpl.getById(id);
      if(upinvoiceDeliverySource != null){
        upinvoiceDeliverySource = ObjectCopyUtils.copyProperties(invoiceDeliverySource,upinvoiceDeliverySource,true);
      }
      return XfR.ok(invoiceDeliverySourceServiceImpl.updateById(upinvoiceDeliverySource));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoicedeliverysources/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceDeliverySourceServiceImpl.removeById(id));
  }

  @PostMapping("/invoicedeliverysources/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_delivery_source");
     params.put("request", condition);

     return XfR.ok(invoiceDeliverySourceServiceImpl.querys(params));
  }

}
