package com.xforceplus.productstandardbizflowt.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.productstandardbizflowt.entity.SystemMessageTemplate;
import com.xforceplus.productstandardbizflowt.service.ISystemMessageTemplateService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 系统消息模版对象前端控制器
 *
 * @author ultraman
 * @date 2025-04-01
 */
@RestController
public class SystemMessageTemplateController {

  @Autowired
  private ISystemMessageTemplateService systemMessageTemplateServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param systemMessageTemplate 系统消息模版对象
   * @return
   */
  @GetMapping("/systemmessagetemplates" )
  public XfR getSystemMessageTemplates(XfPage page, SystemMessageTemplate systemMessageTemplate) {
    return XfR.ok(systemMessageTemplateServiceImpl.page(page, Wrappers.query(systemMessageTemplate)));
  }

  /**
   * 通过id查询系统消息模版对象
   * @param  id
   * @return XfR
   */
  @GetMapping("/systemmessagetemplates/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(systemMessageTemplateServiceImpl.getById(id));
  }

  /**
   * 新增系统消息模版对象
   * @param systemMessageTemplate 系统消息模版对象
   * @return XfR
   */
  @PostMapping("/systemmessagetemplates")
  public XfR save(@RequestBody SystemMessageTemplate systemMessageTemplate) {
     return XfR.ok(systemMessageTemplateServiceImpl.save(systemMessageTemplate));
  }

  /**
   * 修改-传入修改后的全部数据系统消息模版对象
   * @param systemMessageTemplate 系统消息模版对象
   * @return XfR
   */
  @PutMapping("/systemmessagetemplates/{id}")
  public XfR putUpdate(@RequestBody SystemMessageTemplate systemMessageTemplate,@PathVariable Long id) {
      systemMessageTemplate.setId(id);
      return XfR.ok(systemMessageTemplateServiceImpl.updateById(systemMessageTemplate));
  }

  /**
   * 修改-传入修改的数据系统消息模版对象
   * @param systemMessageTemplate 系统消息模版对象
   * @return XfR
   */
  @PatchMapping("/systemmessagetemplates/{id}")
  public XfR patchUpdate(@RequestBody SystemMessageTemplate systemMessageTemplate,@PathVariable Long id) {
      SystemMessageTemplate upsystemMessageTemplate = systemMessageTemplateServiceImpl.getById(id);
      if(upsystemMessageTemplate != null){
        upsystemMessageTemplate = ObjectCopyUtils.copyProperties(systemMessageTemplate,upsystemMessageTemplate,true);
      }
      return XfR.ok(systemMessageTemplateServiceImpl.updateById(upsystemMessageTemplate));
  }

  /**
   * 通过id删除系统消息模版对象
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/systemmessagetemplates/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(systemMessageTemplateServiceImpl.removeById(id));
  }

  @PostMapping("/systemmessagetemplates/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "system_message_template");
     params.put("request", condition);

     return XfR.ok(systemMessageTemplateServiceImpl.querys(params));
  }

}
