package com.xforceplus.psccreqmgmt.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * current_status
 * </p>
 *
 * @author ultraman
 * @since 2024-02-29
 */
public enum CurrentStatus {

    _1("1", "待开始"),
    _2("2", "进行中"),
    _3("3", "已完成"),
    _4("4", "已暂停"),
    _5("5", "已取消");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    CurrentStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static CurrentStatus fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            default:
                return null;
        }
    }
}
