package com.xforceplus.psccreqmgmt.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * department_the_proposer_belongs
 * </p>
 *
 * @author ultraman
 * @since 2024-02-29
 */
public enum DepartmentTheProposerBelongs {

    PRJCENTER("PRJCENTER", "交付中心"),
    PHOENIX("PHOENIX", "销项产品线"),
    JXCPX("JXCPX", "进项产品线"),
    COOP("COOP", "协同产品线"),
    PLAT("PLAT", "业务中台-用户中心"),
    ULTRAMAN("ULTRAMAN", "奥特曼"),
    T1("T1", "税件"),
    OPENAPI("OPENAPI", "OpenAPI"),
    IP("IP", "集成平台");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    DepartmentTheProposerBelongs(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DepartmentTheProposerBelongs fromCode(String code){
        switch(code) {
            case "PRJCENTER":
                return PRJCENTER;
            case "PHOENIX":
                return PHOENIX;
            case "JXCPX":
                return JXCPX;
            case "COOP":
                return COOP;
            case "PLAT":
                return PLAT;
            case "ULTRAMAN":
                return ULTRAMAN;
            case "T1":
                return T1;
            case "OPENAPI":
                return OPENAPI;
            case "IP":
                return IP;
            default:
                return null;
        }
    }
}
