package com.xforceplus.psccreqmgmt.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * milestone
 * </p>
 *
 * @author ultraman
 * @since 2024-02-29
 */
public enum Milestone {

    _1("1", "售前"),
    _2("2", "项目启动"),
    _3("3", "需求分析"),
    _4("4", "系统设计开发"),
    _5("5", "上线保驾"),
    _6("6", "转交运维");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    Milestone(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static Milestone fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            default:
                return null;
        }
    }
}
