package com.xforceplus.psccreqmgmt.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * nature_of_demand
 * </p>
 *
 * @author ultraman
 * @since 2024-02-29
 */
public enum NatureOfDemand {

    _1("1", "ARR看护免费需求"),
    _2("2", "仅评估人天"),
    _3("3", "SOW范围内需求"),
    _4("4", "SOW范围内需求变更");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    NatureOfDemand(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static NatureOfDemand fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            default:
                return null;
        }
    }
}
