package com.xforceplus.psccreqmgmt.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * operation_type
 * </p>
 *
 * @author ultraman
 * @since 2024-02-29
 */
public enum OperationType {

    _1("1", "修改"),
    _2("2", "提交"),
    _3("3", "评审"),
    _4("4", "排期"),
    _5("5", "上线"),
    _6("6", "验收"),
    _7("7", "作废"),
    _8("8", "编辑");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    OperationType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static OperationType fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            case "7":
                return _7;
            case "8":
                return _8;
            default:
                return null;
        }
    }
}
