package com.xforceplus.psccreqmgmt.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * pitch_stage
 * </p>
 *
 * @author ultraman
 * @since 2024-02-29
 */
public enum PitchStage {

    _1("1", "项目启动"),
    _2("2", "需求分析"),
    _3("3", "系统设计开发"),
    _4("4", "UAT测试"),
    _5("5", "上线验收"),
    _6("6", "转交运维"),
    _7("7", "系统运维"),
    _0("0", "售前BD");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    PitchStage(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PitchStage fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            case "7":
                return _7;
            case "0":
                return _0;
            default:
                return null;
        }
    }
}
