package com.xforceplus.psccreqmgmt.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * project_classification
 * </p>
 *
 * @author ultraman
 * @since 2024-02-29
 */
public enum ProjectClassification {

    A("A", "A"),
    B("B", "B"),
    C1("C1", "C1"),
    C2("C2", "C2"),
    D("D", "D");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ProjectClassification(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ProjectClassification fromCode(String code){
        switch(code) {
            case "A":
                return A;
            case "B":
                return B;
            case "C1":
                return C1;
            case "C2":
                return C2;
            case "D":
                return D;
            default:
                return null;
        }
    }
}
