package com.xforceplus.psccreqmgmt.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * project_staging
 * </p>
 *
 * @author ultraman
 * @since 2024-02-29
 */
public enum ProjectStaging {

    _1("1", "无分期"),
    _2("2", "EPC系统对接发票平台销项开票项目"),
    _3("3", "PAPCN推广"),
    _4("4", "卓越扫码开票"),
    _5("5", "震坤行+乐企数电纸票对接"),
    _6("6", "银联商务数电通道升级项目"),
    _7("7", "益海嘉里商联升级项目");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ProjectStaging(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ProjectStaging fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            case "7":
                return _7;
            default:
                return null;
        }
    }
}
