package com.xforceplus.psccreqmgmt.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * reason_for_failure_acceptance
 * </p>
 *
 * @author ultraman
 * @since 2024-02-29
 */
public enum ReasonForFailureAcceptance {

    BUG问题("BUG问题", "BUG问题"),
    未满足需求("未满足需求", "未满足需求"),
    需求漫延("需求漫延", "需求漫延");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ReasonForFailureAcceptance(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ReasonForFailureAcceptance fromCode(String code){
        switch(code) {
            case "BUG问题":
                return BUG问题;
            case "未满足需求":
                return 未满足需求;
            case "需求漫延":
                return 需求漫延;
            default:
                return null;
        }
    }
}
